from __future__ import print_function
from _mock import _Mock




compilers = _Mock()

cpu = _Mock()

dummy_fortran_file = _Mock()

intel_version_match = _Mock()

simple_version_match = _Mock()

sys = _Mock()



class BaseIntelFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class FCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelEM64TFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intelem'
  description = 'Intel Fortran Compiler for 64-bit apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelEM64VisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelvem'
  description = 'Intel Visual Fortran Compiler for 64-bit apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intel'
  description = 'Intel Fortran Compiler for 32-bit apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelItaniumFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intele'
  description = 'Intel Fortran Compiler for Itanium apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelItaniumVisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelev'
  description = 'Intel Visual Fortran Compiler for Itanium apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelVisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelv'
  description = 'Intel Visual Fortran Compiler for 32-bit apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

