/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import scala.actors.threadpool.Callable;
import scala.actors.threadpool.CancellationException;
import scala.actors.threadpool.ExecutionException;
import scala.actors.threadpool.ExecutorCompletionService;
import scala.actors.threadpool.ExecutorService;
import scala.actors.threadpool.Future;
import scala.actors.threadpool.FutureTask;
import scala.actors.threadpool.RunnableFuture;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.TimeoutException;
import scala.actors.threadpool.helpers.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutorService
implements ExecutorService {
    protected RunnableFuture newTaskFor(Runnable runnable, Object object) {
        return new FutureTask(runnable, object);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    @Override
    public Future submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public Future submit(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, object);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public Future submit(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    /*
     * Unable to fully structure code
     */
    private Object doInvokeAny(Collection var1_1, boolean var2_2, long var3_3) throws InterruptedException, ExecutionException, TimeoutException {
        block18: {
            if (var1_1 == null) {
                throw new NullPointerException();
            }
            var5_4 = var1_1.size();
            if (var5_4 == 0) {
                throw new IllegalArgumentException();
            }
            var6_5 = new ArrayList<Future>(var5_4);
            var7_6 = new ExecutorCompletionService(this);
            var8_7 = null;
            var9_8 = var2_2 != false ? Utils.nanoTime() : 0L;
            var11_9 = var1_1.iterator();
            var6_5.add(var7_6.submit((Callable)var11_9.next()));
            --var5_4;
            var12_10 = 1;
            while (true) lbl-1000:
            // 4 sources

            {
                if ((var13_11 = var7_6.poll()) == null) {
                    if (var5_4 > 0) {
                        --var5_4;
                        var6_5.add(var7_6.submit((Callable)var11_9.next()));
                        ++var12_10;
                    } else {
                        if (var12_10 == 0) ** break;
                        if (var2_2) {
                            var13_11 = var7_6.poll(var3_3, TimeUnit.NANOSECONDS);
                            if (var13_11 == null) {
                                throw new TimeoutException();
                            }
                            var14_12 = Utils.nanoTime();
                            var3_3 -= var14_12 - var9_8;
                            var9_8 = var14_12;
                        } else {
                            var13_11 = var7_6.take();
                        }
                    }
                }
                if (var13_11 == null) continue;
                --var12_10;
                try {
                    var14_13 = var13_11.get();
                    return var14_13;
                }
                catch (InterruptedException var14_14) {
                    throw var14_14;
                }
                catch (ExecutionException var14_15) {
                    var8_7 = var14_15;
                }
                catch (RuntimeException var14_16) {
                    var8_7 = new ExecutionException(var14_16);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (var8_7 != null) break block18;
            var8_7 = new ExecutionException();
        }
        throw var8_7;
        finally {
            var15_17 = var6_5.iterator();
            while (var15_17.hasNext()) {
                ((Future)var15_17.next()).cancel(true);
            }
        }
    }

    @Override
    public Object invokeAny(Collection collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            assert (false);
            return null;
        }
    }

    @Override
    public Object invokeAny(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Future> invokeAll(Collection collection) throws InterruptedException {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<RunnableFuture> arrayList = new ArrayList<RunnableFuture>(collection.size());
        boolean bl = false;
        try {
            Object object = collection.iterator();
            while (object.hasNext()) {
                RunnableFuture object2 = this.newTaskFor((Callable)object.next());
                arrayList.add(object2);
                this.execute(object2);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl = true;
            object = arrayList;
            return object;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Future> invokeAll(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException {
        if (collection == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ArrayList<Future> arrayList = new ArrayList<Future>(collection.size());
        boolean bl = false;
        try {
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                arrayList.add(this.newTaskFor((Callable)iterator2.next()));
            }
            long l3 = Utils.nanoTime();
            Iterator iterator3 = arrayList.iterator();
            while (iterator3.hasNext()) {
                this.execute((Runnable)iterator3.next());
                long l4 = Utils.nanoTime();
                l3 = l4;
                if ((l2 -= l4 - l3) > 0L) continue;
                ArrayList<Future> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l2 <= 0L) {
                    ArrayList<Future> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<Future> arrayList4 = arrayList;
                    if (!bl) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l5 = Utils.nanoTime();
                l2 -= l5 - l3;
                l3 = l5;
            }
            bl = true;
            ArrayList<Future> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }
}

