/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JWindow;
import org.sikuli.guide.SikuliGuide;
import org.sikuli.guide.SingletonInteractionTarget;
import org.sikuli.script.Env;
import org.sikuli.script.Location;
import org.sikuli.script.OS;
import org.sikuli.script.Region;
import org.sikuli.script.TransparentWindow;

public class Spotlight
extends TransparentWindow
implements SingletonInteractionTarget {
    SikuliGuide guide;
    public Point current = null;
    public Point to = null;
    Region target;
    Region canvas;

    public Spotlight(SikuliGuide sikuliGuide, Region region) {
        this.guide = sikuliGuide;
        this.canvas = sikuliGuide.getRegion();
        this.target = region;
        this.setBackground(null);
        this.getContentPane().setBackground(null);
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBackground(color);
        this.getContentPane().setBackground(color);
        this.setOpacity(0.7f);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawRayPolygon(graphics, this.current, this.target.getRect());
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.0f));
    }

    public void drawRayPolygon(Graphics graphics, Point point, Rectangle rectangle) {
        int[] nArray;
        int[] nArray2;
        if (point == null || rectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle2 = rectangle;
        int[] nArray3 = new int[]{rectangle2.x, rectangle2.x, rectangle2.x + rectangle2.width, rectangle2.x + rectangle2.width};
        int[] nArray4 = new int[]{rectangle2.y, rectangle2.y + rectangle2.height, rectangle2.y + rectangle2.height, rectangle2.height};
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(new Point(rectangle2.x, rectangle2.y));
        arrayList.add(new Point(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height));
        arrayList.add(new Point(rectangle2.x + rectangle2.width, rectangle2.y));
        arrayList.add(new Point(rectangle2.x, rectangle2.y + rectangle2.height));
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return (int)(Spotlight.this.current.distance((Point)object) - Spotlight.this.current.distance((Point)object2));
            }
        });
        int n = 5;
        if ((double)point.x > rectangle.getMinX() - 5.0 && (double)point.x < rectangle.getMaxX() + 5.0 || (double)point.y > rectangle.getMinY() - 5.0 && (double)point.y < rectangle.getMaxY() + 5.0) {
            nArray2 = new int[3];
            nArray = new int[3];
            nArray2[0] = point.x;
            nArray2[1] = ((Point)arrayList.get((int)0)).x;
            nArray2[2] = ((Point)arrayList.get((int)1)).x;
            nArray[0] = point.y;
            nArray[1] = ((Point)arrayList.get((int)0)).y;
            nArray[2] = ((Point)arrayList.get((int)1)).y;
        } else {
            nArray2 = new int[4];
            nArray = new int[4];
            nArray2[0] = point.x;
            nArray2[1] = ((Point)arrayList.get((int)2)).x;
            nArray2[2] = ((Point)arrayList.get((int)0)).x;
            nArray2[3] = ((Point)arrayList.get((int)1)).x;
            nArray[0] = point.y;
            nArray[1] = ((Point)arrayList.get((int)2)).y;
            nArray[2] = ((Point)arrayList.get((int)0)).y;
            nArray[3] = ((Point)arrayList.get((int)1)).y;
        }
        Polygon polygon = new Polygon(nArray2, nArray, nArray2.length);
        BasicStroke basicStroke = new BasicStroke(3.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(Color.black);
        graphics2D.setColor(Color.red);
        graphics2D.fillPolygon(polygon);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void drawPolylineArrow(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2) {
        Object object = Array.get(nArray, nArray.length - 2);
        Object object2 = Array.get(nArray, nArray.length - 1);
        Integer n3 = (Integer)object;
        int n4 = n3;
        Integer n5 = (Integer)object2;
        int n6 = n5;
        Object object3 = Array.get(nArray2, nArray2.length - 2);
        Object object4 = Array.get(nArray2, nArray2.length - 1);
        Integer n7 = (Integer)object3;
        int n8 = n7;
        Integer n9 = (Integer)object4;
        int n10 = n9;
        int n11 = n6 - n4;
        int n12 = n10 - n8;
        double d = Math.atan((double)n12 / (double)n11);
        double d2 = (double)n11 < 0.0 ? d + Math.PI : d;
        int n13 = -((int)(Math.cos(d2) * (double)n));
        int n14 = -((int)(Math.sin(d2) * (double)n));
        int n15 = (int)(Math.sin(d2) * (double)n2);
        int n16 = (int)(Math.cos(d2) * (double)n2);
        graphics.drawPolyline(nArray, nArray2, nArray.length);
        graphics.drawLine(n6, n10, n6 + n13 + n15, n10 + n14 - n16);
        graphics.drawLine(n6, n10, n6 + n13 - n15, n10 + n14 + n16);
    }

    public void setFullScreen() {
    }

    public void run() {
    }

    private void closeAfter(float f) {
        try {
            Thread.sleep((int)f * 1000);
        }
        catch (InterruptedException interruptedException) {
            this.close();
            interruptedException.printStackTrace();
        }
        this.close();
    }

    public void toFront() {
        if (Env.getOS() == OS.MAC) {
            Env.getOSUtil().bringWindowToFront((JWindow)((Object)this), true);
        }
        super.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String waitUserAction() {
        this.setBounds(this.guide.getRegion().getRect());
        this.setVisible(true);
        this.toFront();
        Cursor cursor = new Cursor(12);
        Cursor cursor2 = new Cursor(0);
        Cursor cursor3 = null;
        boolean bl = true;
        while (bl) {
            Rectangle rectangle = this.target.getRect();
            Location location = Env.getMouseLocation();
            this.current = new Point(location.x, location.y);
            Cursor cursor4 = null;
            if (rectangle.contains(this.current)) {
                bl = false;
                cursor4 = cursor;
                this.setVisible(false);
                this.dispose();
                SikuliGuide sikuliGuide = this.guide;
                synchronized (sikuliGuide) {
                    ((Object)((Object)this.guide)).notify();
                    this.dispose();
                    return "Next";
                }
            }
            cursor4 = cursor2;
            this.repaint();
            if (cursor4 == cursor3) continue;
            this.setCursor(cursor4);
            cursor3 = cursor4;
        }
        return "Next";
    }
}

