# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

import os
from sphinx_panels import __version__

# -- Project information -----------------------------------------------------

project = "Sphinx-Panels"
copyright = "2020, Executable Books Project"
author = "Chris Sewell"

# The short X.Y version
version = __version__
# The full version, including alpha/beta/rc tags
release = __version__

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ["sphinx_panels"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = "alabaster"

theme_name = os.environ.get("HTML_THEME", "sphinx_rtd_theme")

if theme_name == "sphinx_rtd_theme":
    html_theme = "sphinx_rtd_theme"
elif theme_name == "alabaster":
    html_theme = "alabaster"
    html_css_files = [
        (
            "https://cdnjs.cloudflare.com/ajax/libs/font-awesome"
            "/4.7.0/css/font-awesome.min.css"
        )
    ]
elif theme_name == "pydata_sphinx_theme":
    html_theme = "pydata_sphinx_theme"
    panels_add_bootstrap_css = False
elif theme_name == "sphinx_book_theme":
    html_theme = "sphinx_book_theme"
    panels_add_bootstrap_css = False
    html_theme_options = {
        "single_page": True,
    }
else:
    raise ValueError(f"HTML_THEME name not recognised: {theme_name}")

# ensures all pages are rebuilt if CSS changes
panels_dev_mode = True


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "ExecutableBooksProjectdoc"


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "ExecutableBooksProject.tex",
        "Executable Books Project Documentation",
        "Chris Holdgraf",
        "manual",
    )
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        master_doc,
        "ExecutableBooksProject",
        "Executable Books Project Documentation",
        [author],
        1,
    )
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "ExecutableBooksProject",
        "Executable Books Project Documentation",
        author,
        "ExecutableBooksProject",
        "One line description of project.",
        "Miscellaneous",
    )
]
