#! /usr/bin/ruby -w

## ====================================================================
## Copyright (c) 2008       Martin Hauner
##                          http://subcommander.tigris.org
##
## Subcommander is licensed as described in the file doc/COPYING, which
## you should have received as part of this distribution.
## ====================================================================
##
## Windows build: copy external locale files to build directory.
##

require 'ftools'

$SvnLocale = "c:/Development/Subversion-1.5.1/Release/mo"
$ScDest    = "."


# create dir "subpath" and all intermediate dirs in dir "dstdir"
# todo: replace with ftools: mkpath
def mkdir( dstdir, subpath )
  subpaths = subpath.split('/')
  
  path = dstdir
  subpaths.each { |p|
   path = path + "/" + p   

   if not File.exists? path then
     Dir.mkdir path     
   end
  }
end


# copy subversions locale files to the the proper subdirectory into
# the subcommander Debug and Release build directories.

puts "copying subversion local files.."

Dir.foreach( $SvnLocale ) { |file|
  
  # match ".mo" extension and extract the language
  if file =~ /(.*).mo/ then
    puts "  #{$1}"
  
    # make sure the language target directory exists    
    mkdir $ScDest, "bin/Debug/share/locale/#{$1}/LC_MESSAGES"
    mkdir $ScDest, "bin/Release/share/locale/#{$1}/LC_MESSAGES"

    # copy the language file to the target directories
    File.copy "#{$SvnLocale}/#{file}", "#{$ScDest}/bin/Debug/share/locale/#{$1}/LC_MESSAGES/subversion.mo"
    File.copy "#{$SvnLocale}/#{file}", "#{$ScDest}/bin/Release/share/locale/#{$1}/LC_MESSAGES/subversion.mo"
    
  end
}

puts "..done."
