/* legacy-config.c generated by valac 0.30.1, the Vala compiler
 * generated from legacy-config.vala, do not modify */

/*
 * Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
/* Compatibility with old (gnome-config) configuration files. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "paths.h"
#include <gio/gio.h>
#include "uuid.h"

#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_key_file_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_key_file_free0_ (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GSList* tg_read_files (void);
static void _g_key_file_free0_ (gpointer var);
static void _g_slist_free__g_key_file_free0_ (GSList* self);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
gchar* tg_get_value (GSList* keyfiles, const gchar* group, const gchar* key);
void tg_legacy_convert (GSettings* settings);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_key_file_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_key_file_free (var), NULL));
}


static void _g_slist_free__g_key_file_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_key_file_free0_, NULL);
	g_slist_free (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


GSList* tg_read_files (void) {
	GSList* result = NULL;
	GSList* names = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GSList* keyfiles = NULL;
	GSList* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	names = NULL;
	_tmp0_ = tg_get_sysconf_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome", "config-override", "telegnome", NULL);
	names = g_slist_append (names, _tmp1_);
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_build_filename (_tmp2_, ".gnome2", "telegnome", NULL);
	names = g_slist_append (names, _tmp3_);
	_tmp4_ = tg_get_sysconf_dir ();
	_tmp5_ = g_build_filename (_tmp4_, "gnome", "config", "telegnome", NULL);
	names = g_slist_append (names, _tmp5_);
	keyfiles = NULL;
	_tmp6_ = names;
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp6_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp7_ = NULL;
			gchar* name = NULL;
			_tmp7_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp7_;
			{
				GKeyFile* keyfile = NULL;
				GKeyFile* _tmp8_ = NULL;
				_tmp8_ = g_key_file_new ();
				keyfile = _tmp8_;
				{
					GKeyFile* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					GKeyFile* _tmp11_ = NULL;
					_tmp9_ = keyfile;
					_tmp10_ = name;
					g_key_file_load_from_file (_tmp9_, _tmp10_, G_KEY_FILE_NONE, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch10_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch10_g_key_file_error;
						}
						_g_key_file_free0 (keyfile);
						_g_free0 (name);
						__g_slist_free__g_key_file_free0_0 (keyfiles);
						__g_slist_free__g_free0_0 (names);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp11_ = keyfile;
					keyfile = NULL;
					keyfiles = g_slist_append (keyfiles, _tmp11_);
				}
				goto __finally10;
				__catch10_g_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				goto __finally10;
				__catch10_g_key_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally10:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_key_file_free0 (keyfile);
					_g_free0 (name);
					__g_slist_free__g_key_file_free0_0 (keyfiles);
					__g_slist_free__g_free0_0 (names);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_key_file_free0 (keyfile);
				_g_free0 (name);
			}
		}
	}
	result = keyfiles;
	__g_slist_free__g_free0_0 (names);
	return result;
}


gchar* tg_get_value (GSList* keyfiles, const gchar* group, const gchar* key) {
	gchar* result = NULL;
	GSList* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = keyfiles;
	{
		GSList* keyfile_collection = NULL;
		GSList* keyfile_it = NULL;
		keyfile_collection = _tmp0_;
		for (keyfile_it = keyfile_collection; keyfile_it != NULL; keyfile_it = keyfile_it->next) {
			GKeyFile* keyfile = NULL;
			keyfile = (GKeyFile*) keyfile_it->data;
			{
				{
					gchar* _tmp1_ = NULL;
					GKeyFile* _tmp2_ = NULL;
					const gchar* _tmp3_ = NULL;
					const gchar* _tmp4_ = NULL;
					gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					_tmp2_ = keyfile;
					_tmp3_ = group;
					_tmp4_ = key;
					_tmp5_ = g_key_file_get_string (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
					_tmp1_ = _tmp5_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch11_g_key_file_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp6_ = _tmp1_;
					_tmp1_ = NULL;
					result = _tmp6_;
					_g_free0 (_tmp1_);
					return result;
				}
				goto __finally11;
				__catch11_g_key_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally11:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void tg_legacy_convert (GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSList* keyfiles = NULL;
	GSList* _tmp2_ = NULL;
	gchar* val = NULL;
	gint channel_count = 0;
	gint current_channel = 0;
	GSList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GSList* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GSList* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GSList* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GSList* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GSList* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	GSList* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar** children = NULL;
	gint _tmp53_ = 0;
	gchar** _tmp54_ = NULL;
	gint children_length1 = 0;
	gint _children_size_ = 0;
	GSettings* _tmp115_ = NULL;
	gchar** _tmp116_ = NULL;
	gint _tmp116__length1 = 0;
	GSettings* _tmp117_ = NULL;
	g_return_if_fail (settings != NULL);
	_tmp0_ = settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "legacy-migration-complete");
	if (_tmp1_) {
		return;
	}
	_tmp2_ = tg_read_files ();
	keyfiles = _tmp2_;
	channel_count = 0;
	current_channel = -1;
	_tmp3_ = keyfiles;
	_tmp4_ = tg_get_value (_tmp3_, "Channels", "count");
	_g_free0 (val);
	val = _tmp4_;
	_tmp5_ = val;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = val;
		_tmp7_ = atoi (_tmp6_);
		channel_count = _tmp7_;
	}
	_tmp8_ = keyfiles;
	_tmp9_ = tg_get_value (_tmp8_, "Default", "server");
	_g_free0 (val);
	val = _tmp9_;
	_tmp10_ = val;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = val;
		_tmp12_ = atoi (_tmp11_);
		current_channel = _tmp12_;
	}
	_tmp13_ = keyfiles;
	_tmp14_ = tg_get_value (_tmp13_, "Zooming", "factor");
	_g_free0 (val);
	val = _tmp14_;
	_tmp15_ = val;
	if (_tmp15_ != NULL) {
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		GSettings* _tmp19_ = NULL;
		_tmp17_ = val;
		_tmp18_ = atoi (_tmp17_);
		if (_tmp18_ == 1) {
			_tmp16_ = 1;
		} else {
			_tmp16_ = 2;
		}
		_tmp19_ = settings;
		g_settings_set_int (_tmp19_, "zoom-factor", _tmp16_);
	}
	_tmp20_ = keyfiles;
	_tmp21_ = tg_get_value (_tmp20_, "Paging", "enabled");
	_g_free0 (val);
	val = _tmp21_;
	_tmp22_ = val;
	if (_tmp22_ != NULL) {
		gboolean paging_enabled = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_ = NULL;
		gchar _tmp26_ = '\0';
		gchar _tmp27_ = '\0';
		GSettings* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		_tmp25_ = val;
		_tmp26_ = string_get (_tmp25_, (glong) 0);
		_tmp27_ = g_ascii_tolower (_tmp26_);
		if (_tmp27_ == 't') {
			_tmp24_ = TRUE;
		} else {
			const gchar* _tmp28_ = NULL;
			gchar _tmp29_ = '\0';
			gchar _tmp30_ = '\0';
			_tmp28_ = val;
			_tmp29_ = string_get (_tmp28_, (glong) 0);
			_tmp30_ = g_ascii_tolower (_tmp29_);
			_tmp24_ = _tmp30_ == 'y';
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			const gchar* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			_tmp31_ = val;
			_tmp32_ = atoi (_tmp31_);
			_tmp23_ = _tmp32_ != 0;
		}
		if (_tmp23_) {
			paging_enabled = TRUE;
		} else {
			paging_enabled = FALSE;
		}
		_tmp33_ = settings;
		_tmp34_ = paging_enabled;
		g_settings_set_boolean (_tmp33_, "paging-enabled", _tmp34_);
	}
	_tmp35_ = keyfiles;
	_tmp36_ = tg_get_value (_tmp35_, "Paging", "interval");
	_g_free0 (val);
	val = _tmp36_;
	_tmp37_ = val;
	if (_tmp37_ != NULL) {
		GSettings* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		_tmp38_ = settings;
		_tmp39_ = val;
		_tmp40_ = atoi (_tmp39_);
		g_settings_set_int (_tmp38_, "paging-interval", _tmp40_);
	}
	_tmp41_ = keyfiles;
	_tmp42_ = tg_get_value (_tmp41_, "Paging", "page_nr");
	_g_free0 (val);
	val = _tmp42_;
	_tmp43_ = val;
	if (_tmp43_ != NULL) {
		GSettings* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp44_ = settings;
		_tmp45_ = val;
		_tmp46_ = atoi (_tmp45_);
		g_settings_set_int (_tmp44_, "current-page-number", _tmp46_);
	}
	_tmp47_ = keyfiles;
	_tmp48_ = tg_get_value (_tmp47_, "Paging", "subpage_nr");
	_g_free0 (val);
	val = _tmp48_;
	_tmp49_ = val;
	if (_tmp49_ != NULL) {
		GSettings* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		_tmp50_ = settings;
		_tmp51_ = val;
		_tmp52_ = atoi (_tmp51_);
		g_settings_set_int (_tmp50_, "current-subpage-number", _tmp52_);
	}
	_tmp53_ = channel_count;
	_tmp54_ = g_new0 (gchar*, (_tmp53_ + 1) + 1);
	children = _tmp54_;
	children_length1 = _tmp53_ + 1;
	_children_size_ = children_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp55_ = FALSE;
			_tmp55_ = TRUE;
			while (TRUE) {
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				gchar* channel_group = NULL;
				gint _tmp59_ = 0;
				gchar* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				guint8* uu = NULL;
				guint8* _tmp64_ = NULL;
				gint uu_length1 = 0;
				gint _uu_size_ = 0;
				guint8* _tmp65_ = NULL;
				gint _tmp65__length1 = 0;
				gchar* uuid_bytes = NULL;
				gchar* _tmp66_ = NULL;
				gint uuid_bytes_length1 = 0;
				gint _uuid_bytes_size_ = 0;
				guint8* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gchar* _tmp68_ = NULL;
				gint _tmp68__length1 = 0;
				gchar* uuid = NULL;
				gchar* _tmp69_ = NULL;
				gint _tmp69__length1 = 0;
				gchar* _tmp70_ = NULL;
				gchar* child_path = NULL;
				const gchar* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gchar** _tmp74_ = NULL;
				gint _tmp74__length1 = 0;
				gint _tmp75_ = 0;
				const gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				GSettings* channel_settings = NULL;
				const gchar* _tmp79_ = NULL;
				GSettings* _tmp80_ = NULL;
				GSList* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
				gchar* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				GSList* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				const gchar* _tmp90_ = NULL;
				GSList* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				gchar* _tmp95_ = NULL;
				const gchar* _tmp96_ = NULL;
				GSList* _tmp99_ = NULL;
				const gchar* _tmp100_ = NULL;
				gchar* _tmp101_ = NULL;
				const gchar* _tmp102_ = NULL;
				GSList* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				gchar* _tmp107_ = NULL;
				const gchar* _tmp108_ = NULL;
				gint _tmp111_ = 0;
				gint _tmp112_ = 0;
				if (!_tmp55_) {
					gint _tmp56_ = 0;
					_tmp56_ = i;
					i = _tmp56_ + 1;
				}
				_tmp55_ = FALSE;
				_tmp57_ = i;
				_tmp58_ = channel_count;
				if (!(_tmp57_ < _tmp58_)) {
					break;
				}
				_tmp59_ = i;
				_tmp60_ = g_strdup_printf ("%i", _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strconcat ("Channel", _tmp61_, NULL);
				_tmp63_ = _tmp62_;
				_g_free0 (_tmp61_);
				channel_group = _tmp63_;
				_tmp64_ = g_new0 (guint8, 16);
				uu = _tmp64_;
				uu_length1 = 16;
				_uu_size_ = uu_length1;
				_tmp65_ = uu;
				_tmp65__length1 = uu_length1;
				uuid_generate (_tmp65_);
				_tmp66_ = g_new0 (gchar, 37);
				uuid_bytes = _tmp66_;
				uuid_bytes_length1 = 37;
				_uuid_bytes_size_ = uuid_bytes_length1;
				_tmp67_ = uu;
				_tmp67__length1 = uu_length1;
				_tmp68_ = uuid_bytes;
				_tmp68__length1 = uuid_bytes_length1;
				uuid_unparse (_tmp67_, _tmp68_);
				_tmp69_ = uuid_bytes;
				_tmp69__length1 = uuid_bytes_length1;
				_tmp70_ = g_strdup ((const gchar*) _tmp69_);
				uuid = _tmp70_;
				_tmp71_ = uuid;
				_tmp72_ = string_to_string (_tmp71_);
				_tmp73_ = g_strconcat ("/org/gnome/telegnome/channel/", _tmp72_, "/", NULL);
				child_path = _tmp73_;
				_tmp74_ = children;
				_tmp74__length1 = children_length1;
				_tmp75_ = i;
				_tmp76_ = uuid;
				_tmp77_ = g_strdup (_tmp76_);
				_g_free0 (_tmp74_[_tmp75_]);
				_tmp74_[_tmp75_] = _tmp77_;
				_tmp78_ = _tmp74_[_tmp75_];
				_tmp79_ = child_path;
				_tmp80_ = g_settings_new_with_path ("org.gnome.telegnome.channel", _tmp79_);
				channel_settings = _tmp80_;
				_tmp81_ = keyfiles;
				_tmp82_ = channel_group;
				_tmp83_ = tg_get_value (_tmp81_, _tmp82_, "name");
				_g_free0 (val);
				val = _tmp83_;
				_tmp84_ = val;
				if (_tmp84_ != NULL) {
					GSettings* _tmp85_ = NULL;
					const gchar* _tmp86_ = NULL;
					_tmp85_ = channel_settings;
					_tmp86_ = val;
					g_settings_set_string (_tmp85_, "name", _tmp86_);
				}
				_tmp87_ = keyfiles;
				_tmp88_ = channel_group;
				_tmp89_ = tg_get_value (_tmp87_, _tmp88_, "desc");
				_g_free0 (val);
				val = _tmp89_;
				_tmp90_ = val;
				if (_tmp90_ != NULL) {
					GSettings* _tmp91_ = NULL;
					const gchar* _tmp92_ = NULL;
					_tmp91_ = channel_settings;
					_tmp92_ = val;
					g_settings_set_string (_tmp91_, "description", _tmp92_);
				}
				_tmp93_ = keyfiles;
				_tmp94_ = channel_group;
				_tmp95_ = tg_get_value (_tmp93_, _tmp94_, "page_url");
				_g_free0 (val);
				val = _tmp95_;
				_tmp96_ = val;
				if (_tmp96_ != NULL) {
					GSettings* _tmp97_ = NULL;
					const gchar* _tmp98_ = NULL;
					_tmp97_ = channel_settings;
					_tmp98_ = val;
					g_settings_set_string (_tmp97_, "page-url", _tmp98_);
				}
				_tmp99_ = keyfiles;
				_tmp100_ = channel_group;
				_tmp101_ = tg_get_value (_tmp99_, _tmp100_, "subpage_url");
				_g_free0 (val);
				val = _tmp101_;
				_tmp102_ = val;
				if (_tmp102_ != NULL) {
					GSettings* _tmp103_ = NULL;
					const gchar* _tmp104_ = NULL;
					_tmp103_ = channel_settings;
					_tmp104_ = val;
					g_settings_set_string (_tmp103_, "subpage-url", _tmp104_);
				}
				_tmp105_ = keyfiles;
				_tmp106_ = channel_group;
				_tmp107_ = tg_get_value (_tmp105_, _tmp106_, "country");
				_g_free0 (val);
				val = _tmp107_;
				_tmp108_ = val;
				if (_tmp108_ != NULL) {
					GSettings* _tmp109_ = NULL;
					const gchar* _tmp110_ = NULL;
					_tmp109_ = channel_settings;
					_tmp110_ = val;
					g_settings_set_string (_tmp109_, "country", _tmp110_);
				}
				_tmp111_ = i;
				_tmp112_ = current_channel;
				if (_tmp111_ == _tmp112_) {
					GSettings* _tmp113_ = NULL;
					const gchar* _tmp114_ = NULL;
					_tmp113_ = settings;
					_tmp114_ = uuid;
					g_settings_set_string (_tmp113_, "current-channel", _tmp114_);
				}
				_g_object_unref0 (channel_settings);
				_g_free0 (child_path);
				_g_free0 (uuid);
				uuid_bytes = (g_free (uuid_bytes), NULL);
				uu = (g_free (uu), NULL);
				_g_free0 (channel_group);
			}
		}
	}
	_tmp115_ = settings;
	_tmp116_ = children;
	_tmp116__length1 = children_length1;
	g_settings_set_strv (_tmp115_, "channel-children", _tmp116_);
	_tmp117_ = settings;
	g_settings_set_boolean (_tmp117_, "legacy-migration-complete", TRUE);
	g_settings_sync ();
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val);
	__g_slist_free__g_key_file_free0_0 (keyfiles);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



