package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNatIpCidr invokes the vpc.CreateNatIpCidr API synchronously
func (client *Client) CreateNatIpCidr(request *CreateNatIpCidrRequest) (response *CreateNatIpCidrResponse, err error) {
	response = CreateCreateNatIpCidrResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNatIpCidrWithChan invokes the vpc.CreateNatIpCidr API asynchronously
func (client *Client) CreateNatIpCidrWithChan(request *CreateNatIpCidrRequest) (<-chan *CreateNatIpCidrResponse, <-chan error) {
	responseChan := make(chan *CreateNatIpCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNatIpCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNatIpCidrWithCallback invokes the vpc.CreateNatIpCidr API asynchronously
func (client *Client) CreateNatIpCidrWithCallback(request *CreateNatIpCidrRequest, callback func(response *CreateNatIpCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNatIpCidrResponse
		var err error
		defer close(result)
		response, err = client.CreateNatIpCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNatIpCidrRequest is the request struct for api CreateNatIpCidr
type CreateNatIpCidrRequest struct {
	*requests.RpcRequest
	NatIpCidrDescription string           `position:"Query" name:"NatIpCidrDescription"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NatIpCidrName        string           `position:"Query" name:"NatIpCidrName"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NatIpCidr            string           `position:"Query" name:"NatIpCidr"`
}

// CreateNatIpCidrResponse is the response struct for api CreateNatIpCidr
type CreateNatIpCidrResponse struct {
	*responses.BaseResponse
	NatIpCidrId string `json:"NatIpCidrId" xml:"NatIpCidrId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateNatIpCidrRequest creates a request to invoke CreateNatIpCidr API
func CreateCreateNatIpCidrRequest() (request *CreateNatIpCidrRequest) {
	request = &CreateNatIpCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateNatIpCidr", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNatIpCidrResponse creates a response to parse from CreateNatIpCidr response
func CreateCreateNatIpCidrResponse() (response *CreateNatIpCidrResponse) {
	response = &CreateNatIpCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
