// Code generated by protoc-gen-go. DO NOT EDIT.
// source: proto/gnmi/gnmi.proto

package gnmi

/*
Package gNMI defines a service specification for the gRPC Network Management
Interface. This interface is defined to be a standard interface via which
a network management system ("client") can subscribe to state values,
retrieve snapshots of state information, and manipulate the state of a data
tree supported by a device ("target").

This document references the gNMI Specification which can be found at
http://github.com/openconfig/reference/blob/master/rpc/gnmi
*/

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
import any "github.com/golang/protobuf/ptypes/any"
import gnmi_ext "github.com/openconfig/gnmi/proto/gnmi_ext"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Encoding defines the value encoding formats that are supported by the gNMI
// protocol. These encodings are used by both the client (when sending Set
// messages to modify the state of the target) and the target when serializing
// data to be returned to the client (in both Subscribe and Get RPCs).
// Reference: gNMI Specification Section 2.3
type Encoding int32

const (
	Encoding_JSON      Encoding = 0
	Encoding_BYTES     Encoding = 1
	Encoding_PROTO     Encoding = 2
	Encoding_ASCII     Encoding = 3
	Encoding_JSON_IETF Encoding = 4
)

var Encoding_name = map[int32]string{
	0: "JSON",
	1: "BYTES",
	2: "PROTO",
	3: "ASCII",
	4: "JSON_IETF",
}
var Encoding_value = map[string]int32{
	"JSON":      0,
	"BYTES":     1,
	"PROTO":     2,
	"ASCII":     3,
	"JSON_IETF": 4,
}

func (x Encoding) String() string {
	return proto.EnumName(Encoding_name, int32(x))
}
func (Encoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{0}
}

// SubscriptionMode is the mode of the subscription, specifying how the
// target must return values in a subscription.
// Reference: gNMI Specification Section 3.5.1.3
type SubscriptionMode int32

const (
	SubscriptionMode_TARGET_DEFINED SubscriptionMode = 0
	SubscriptionMode_ON_CHANGE      SubscriptionMode = 1
	SubscriptionMode_SAMPLE         SubscriptionMode = 2
)

var SubscriptionMode_name = map[int32]string{
	0: "TARGET_DEFINED",
	1: "ON_CHANGE",
	2: "SAMPLE",
}
var SubscriptionMode_value = map[string]int32{
	"TARGET_DEFINED": 0,
	"ON_CHANGE":      1,
	"SAMPLE":         2,
}

func (x SubscriptionMode) String() string {
	return proto.EnumName(SubscriptionMode_name, int32(x))
}
func (SubscriptionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{1}
}

// Mode of the subscription.
type SubscriptionList_Mode int32

const (
	SubscriptionList_STREAM SubscriptionList_Mode = 0
	SubscriptionList_ONCE   SubscriptionList_Mode = 1
	SubscriptionList_POLL   SubscriptionList_Mode = 2
)

var SubscriptionList_Mode_name = map[int32]string{
	0: "STREAM",
	1: "ONCE",
	2: "POLL",
}
var SubscriptionList_Mode_value = map[string]int32{
	"STREAM": 0,
	"ONCE":   1,
	"POLL":   2,
}

func (x SubscriptionList_Mode) String() string {
	return proto.EnumName(SubscriptionList_Mode_name, int32(x))
}
func (SubscriptionList_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{12, 0}
}

// The operation that was associated with the Path specified.
type UpdateResult_Operation int32

const (
	UpdateResult_INVALID UpdateResult_Operation = 0
	UpdateResult_DELETE  UpdateResult_Operation = 1
	UpdateResult_REPLACE UpdateResult_Operation = 2
	UpdateResult_UPDATE  UpdateResult_Operation = 3
)

var UpdateResult_Operation_name = map[int32]string{
	0: "INVALID",
	1: "DELETE",
	2: "REPLACE",
	3: "UPDATE",
}
var UpdateResult_Operation_value = map[string]int32{
	"INVALID": 0,
	"DELETE":  1,
	"REPLACE": 2,
	"UPDATE":  3,
}

func (x UpdateResult_Operation) String() string {
	return proto.EnumName(UpdateResult_Operation_name, int32(x))
}
func (UpdateResult_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{19, 0}
}

// Type of elements within the data tree.
type GetRequest_DataType int32

const (
	GetRequest_ALL    GetRequest_DataType = 0
	GetRequest_CONFIG GetRequest_DataType = 1
	GetRequest_STATE  GetRequest_DataType = 2
	// Data elements marked in the schema as operational. This refers to data
	// elements whose value relates to the state of processes or interactions
	// running on the device.
	GetRequest_OPERATIONAL GetRequest_DataType = 3
)

var GetRequest_DataType_name = map[int32]string{
	0: "ALL",
	1: "CONFIG",
	2: "STATE",
	3: "OPERATIONAL",
}
var GetRequest_DataType_value = map[string]int32{
	"ALL":         0,
	"CONFIG":      1,
	"STATE":       2,
	"OPERATIONAL": 3,
}

func (x GetRequest_DataType) String() string {
	return proto.EnumName(GetRequest_DataType_name, int32(x))
}
func (GetRequest_DataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{20, 0}
}

// Notification is a re-usable message that is used to encode data from the
// target to the client. A Notification carries two types of changes to the data
// tree:
//  - Deleted values (delete) - a set of paths that have been removed from the
//    data tree.
//  - Updated values (update) - a set of path-value pairs indicating the path
//    whose value has changed in the data tree.
// Reference: gNMI Specification Section 2.1
type Notification struct {
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Prefix    *Path `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// An alias for the path specified in the prefix field.
	// Reference: gNMI Specification Section 2.4.2
	Alias  string    `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	Update []*Update `protobuf:"bytes,4,rep,name=update,proto3" json:"update,omitempty"`
	Delete []*Path   `protobuf:"bytes,5,rep,name=delete,proto3" json:"delete,omitempty"`
	// This notification contains a set of paths that are always updated together
	// referenced by a globally unique prefix.
	Atomic               bool     `protobuf:"varint,6,opt,name=atomic,proto3" json:"atomic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Notification) Reset()         { *m = Notification{} }
func (m *Notification) String() string { return proto.CompactTextString(m) }
func (*Notification) ProtoMessage()    {}
func (*Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{0}
}
func (m *Notification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Notification.Unmarshal(m, b)
}
func (m *Notification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Notification.Marshal(b, m, deterministic)
}
func (dst *Notification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Notification.Merge(dst, src)
}
func (m *Notification) XXX_Size() int {
	return xxx_messageInfo_Notification.Size(m)
}
func (m *Notification) XXX_DiscardUnknown() {
	xxx_messageInfo_Notification.DiscardUnknown(m)
}

var xxx_messageInfo_Notification proto.InternalMessageInfo

func (m *Notification) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Notification) GetPrefix() *Path {
	if m != nil {
		return m.Prefix
	}
	return nil
}

func (m *Notification) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Notification) GetUpdate() []*Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *Notification) GetDelete() []*Path {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *Notification) GetAtomic() bool {
	if m != nil {
		return m.Atomic
	}
	return false
}

// Update is a re-usable message that is used to store a particular Path,
// Value pair.
// Reference: gNMI Specification Section 2.1
type Update struct {
	Path                 *Path       `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Value                *Value      `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"` // Deprecated: Do not use.
	Val                  *TypedValue `protobuf:"bytes,3,opt,name=val,proto3" json:"val,omitempty"`
	Duplicates           uint32      `protobuf:"varint,4,opt,name=duplicates,proto3" json:"duplicates,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Update) Reset()         { *m = Update{} }
func (m *Update) String() string { return proto.CompactTextString(m) }
func (*Update) ProtoMessage()    {}
func (*Update) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{1}
}
func (m *Update) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Update.Unmarshal(m, b)
}
func (m *Update) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Update.Marshal(b, m, deterministic)
}
func (dst *Update) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Update.Merge(dst, src)
}
func (m *Update) XXX_Size() int {
	return xxx_messageInfo_Update.Size(m)
}
func (m *Update) XXX_DiscardUnknown() {
	xxx_messageInfo_Update.DiscardUnknown(m)
}

var xxx_messageInfo_Update proto.InternalMessageInfo

func (m *Update) GetPath() *Path {
	if m != nil {
		return m.Path
	}
	return nil
}

// Deprecated: Do not use.
func (m *Update) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Update) GetVal() *TypedValue {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *Update) GetDuplicates() uint32 {
	if m != nil {
		return m.Duplicates
	}
	return 0
}

// TypedValue is used to encode a value being sent between the client and
// target (originated by either entity).
type TypedValue struct {
	// One of the fields within the val oneof is populated with the value
	// of the update. The type of the value being included in the Update
	// determines which field should be populated. In the case that the
	// encoding is a particular form of the base protobuf type, a specific
	// field is used to store the value (e.g., json_val).
	//
	// Types that are valid to be assigned to Value:
	//	*TypedValue_StringVal
	//	*TypedValue_IntVal
	//	*TypedValue_UintVal
	//	*TypedValue_BoolVal
	//	*TypedValue_BytesVal
	//	*TypedValue_FloatVal
	//	*TypedValue_DecimalVal
	//	*TypedValue_LeaflistVal
	//	*TypedValue_AnyVal
	//	*TypedValue_JsonVal
	//	*TypedValue_JsonIetfVal
	//	*TypedValue_AsciiVal
	//	*TypedValue_ProtoBytes
	Value                isTypedValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TypedValue) Reset()         { *m = TypedValue{} }
func (m *TypedValue) String() string { return proto.CompactTextString(m) }
func (*TypedValue) ProtoMessage()    {}
func (*TypedValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{2}
}
func (m *TypedValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TypedValue.Unmarshal(m, b)
}
func (m *TypedValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TypedValue.Marshal(b, m, deterministic)
}
func (dst *TypedValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TypedValue.Merge(dst, src)
}
func (m *TypedValue) XXX_Size() int {
	return xxx_messageInfo_TypedValue.Size(m)
}
func (m *TypedValue) XXX_DiscardUnknown() {
	xxx_messageInfo_TypedValue.DiscardUnknown(m)
}

var xxx_messageInfo_TypedValue proto.InternalMessageInfo

type isTypedValue_Value interface {
	isTypedValue_Value()
}

type TypedValue_StringVal struct {
	StringVal string `protobuf:"bytes,1,opt,name=string_val,json=stringVal,proto3,oneof"`
}

type TypedValue_IntVal struct {
	IntVal int64 `protobuf:"varint,2,opt,name=int_val,json=intVal,proto3,oneof"`
}

type TypedValue_UintVal struct {
	UintVal uint64 `protobuf:"varint,3,opt,name=uint_val,json=uintVal,proto3,oneof"`
}

type TypedValue_BoolVal struct {
	BoolVal bool `protobuf:"varint,4,opt,name=bool_val,json=boolVal,proto3,oneof"`
}

type TypedValue_BytesVal struct {
	BytesVal []byte `protobuf:"bytes,5,opt,name=bytes_val,json=bytesVal,proto3,oneof"`
}

type TypedValue_FloatVal struct {
	FloatVal float32 `protobuf:"fixed32,6,opt,name=float_val,json=floatVal,proto3,oneof"`
}

type TypedValue_DecimalVal struct {
	DecimalVal *Decimal64 `protobuf:"bytes,7,opt,name=decimal_val,json=decimalVal,proto3,oneof"`
}

type TypedValue_LeaflistVal struct {
	LeaflistVal *ScalarArray `protobuf:"bytes,8,opt,name=leaflist_val,json=leaflistVal,proto3,oneof"`
}

type TypedValue_AnyVal struct {
	AnyVal *any.Any `protobuf:"bytes,9,opt,name=any_val,json=anyVal,proto3,oneof"`
}

type TypedValue_JsonVal struct {
	JsonVal []byte `protobuf:"bytes,10,opt,name=json_val,json=jsonVal,proto3,oneof"`
}

type TypedValue_JsonIetfVal struct {
	JsonIetfVal []byte `protobuf:"bytes,11,opt,name=json_ietf_val,json=jsonIetfVal,proto3,oneof"`
}

type TypedValue_AsciiVal struct {
	AsciiVal string `protobuf:"bytes,12,opt,name=ascii_val,json=asciiVal,proto3,oneof"`
}

type TypedValue_ProtoBytes struct {
	ProtoBytes []byte `protobuf:"bytes,13,opt,name=proto_bytes,json=protoBytes,proto3,oneof"`
}

func (*TypedValue_StringVal) isTypedValue_Value() {}

func (*TypedValue_IntVal) isTypedValue_Value() {}

func (*TypedValue_UintVal) isTypedValue_Value() {}

func (*TypedValue_BoolVal) isTypedValue_Value() {}

func (*TypedValue_BytesVal) isTypedValue_Value() {}

func (*TypedValue_FloatVal) isTypedValue_Value() {}

func (*TypedValue_DecimalVal) isTypedValue_Value() {}

func (*TypedValue_LeaflistVal) isTypedValue_Value() {}

func (*TypedValue_AnyVal) isTypedValue_Value() {}

func (*TypedValue_JsonVal) isTypedValue_Value() {}

func (*TypedValue_JsonIetfVal) isTypedValue_Value() {}

func (*TypedValue_AsciiVal) isTypedValue_Value() {}

func (*TypedValue_ProtoBytes) isTypedValue_Value() {}

func (m *TypedValue) GetValue() isTypedValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *TypedValue) GetStringVal() string {
	if x, ok := m.GetValue().(*TypedValue_StringVal); ok {
		return x.StringVal
	}
	return ""
}

func (m *TypedValue) GetIntVal() int64 {
	if x, ok := m.GetValue().(*TypedValue_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (m *TypedValue) GetUintVal() uint64 {
	if x, ok := m.GetValue().(*TypedValue_UintVal); ok {
		return x.UintVal
	}
	return 0
}

func (m *TypedValue) GetBoolVal() bool {
	if x, ok := m.GetValue().(*TypedValue_BoolVal); ok {
		return x.BoolVal
	}
	return false
}

func (m *TypedValue) GetBytesVal() []byte {
	if x, ok := m.GetValue().(*TypedValue_BytesVal); ok {
		return x.BytesVal
	}
	return nil
}

func (m *TypedValue) GetFloatVal() float32 {
	if x, ok := m.GetValue().(*TypedValue_FloatVal); ok {
		return x.FloatVal
	}
	return 0
}

func (m *TypedValue) GetDecimalVal() *Decimal64 {
	if x, ok := m.GetValue().(*TypedValue_DecimalVal); ok {
		return x.DecimalVal
	}
	return nil
}

func (m *TypedValue) GetLeaflistVal() *ScalarArray {
	if x, ok := m.GetValue().(*TypedValue_LeaflistVal); ok {
		return x.LeaflistVal
	}
	return nil
}

func (m *TypedValue) GetAnyVal() *any.Any {
	if x, ok := m.GetValue().(*TypedValue_AnyVal); ok {
		return x.AnyVal
	}
	return nil
}

func (m *TypedValue) GetJsonVal() []byte {
	if x, ok := m.GetValue().(*TypedValue_JsonVal); ok {
		return x.JsonVal
	}
	return nil
}

func (m *TypedValue) GetJsonIetfVal() []byte {
	if x, ok := m.GetValue().(*TypedValue_JsonIetfVal); ok {
		return x.JsonIetfVal
	}
	return nil
}

func (m *TypedValue) GetAsciiVal() string {
	if x, ok := m.GetValue().(*TypedValue_AsciiVal); ok {
		return x.AsciiVal
	}
	return ""
}

func (m *TypedValue) GetProtoBytes() []byte {
	if x, ok := m.GetValue().(*TypedValue_ProtoBytes); ok {
		return x.ProtoBytes
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TypedValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TypedValue_OneofMarshaler, _TypedValue_OneofUnmarshaler, _TypedValue_OneofSizer, []interface{}{
		(*TypedValue_StringVal)(nil),
		(*TypedValue_IntVal)(nil),
		(*TypedValue_UintVal)(nil),
		(*TypedValue_BoolVal)(nil),
		(*TypedValue_BytesVal)(nil),
		(*TypedValue_FloatVal)(nil),
		(*TypedValue_DecimalVal)(nil),
		(*TypedValue_LeaflistVal)(nil),
		(*TypedValue_AnyVal)(nil),
		(*TypedValue_JsonVal)(nil),
		(*TypedValue_JsonIetfVal)(nil),
		(*TypedValue_AsciiVal)(nil),
		(*TypedValue_ProtoBytes)(nil),
	}
}

func _TypedValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TypedValue)
	// value
	switch x := m.Value.(type) {
	case *TypedValue_StringVal:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringVal)
	case *TypedValue_IntVal:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntVal))
	case *TypedValue_UintVal:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.UintVal))
	case *TypedValue_BoolVal:
		t := uint64(0)
		if x.BoolVal {
			t = 1
		}
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *TypedValue_BytesVal:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BytesVal)
	case *TypedValue_FloatVal:
		b.EncodeVarint(6<<3 | proto.WireFixed32)
		b.EncodeFixed32(uint64(math.Float32bits(x.FloatVal)))
	case *TypedValue_DecimalVal:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DecimalVal); err != nil {
			return err
		}
	case *TypedValue_LeaflistVal:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaflistVal); err != nil {
			return err
		}
	case *TypedValue_AnyVal:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AnyVal); err != nil {
			return err
		}
	case *TypedValue_JsonVal:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.JsonVal)
	case *TypedValue_JsonIetfVal:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.JsonIetfVal)
	case *TypedValue_AsciiVal:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.AsciiVal)
	case *TypedValue_ProtoBytes:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ProtoBytes)
	case nil:
	default:
		return fmt.Errorf("TypedValue.Value has unexpected type %T", x)
	}
	return nil
}

func _TypedValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TypedValue)
	switch tag {
	case 1: // value.string_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &TypedValue_StringVal{x}
		return true, err
	case 2: // value.int_val
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &TypedValue_IntVal{int64(x)}
		return true, err
	case 3: // value.uint_val
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &TypedValue_UintVal{x}
		return true, err
	case 4: // value.bool_val
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &TypedValue_BoolVal{x != 0}
		return true, err
	case 5: // value.bytes_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &TypedValue_BytesVal{x}
		return true, err
	case 6: // value.float_val
		if wire != proto.WireFixed32 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed32()
		m.Value = &TypedValue_FloatVal{math.Float32frombits(uint32(x))}
		return true, err
	case 7: // value.decimal_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Decimal64)
		err := b.DecodeMessage(msg)
		m.Value = &TypedValue_DecimalVal{msg}
		return true, err
	case 8: // value.leaflist_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ScalarArray)
		err := b.DecodeMessage(msg)
		m.Value = &TypedValue_LeaflistVal{msg}
		return true, err
	case 9: // value.any_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(any.Any)
		err := b.DecodeMessage(msg)
		m.Value = &TypedValue_AnyVal{msg}
		return true, err
	case 10: // value.json_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &TypedValue_JsonVal{x}
		return true, err
	case 11: // value.json_ietf_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &TypedValue_JsonIetfVal{x}
		return true, err
	case 12: // value.ascii_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &TypedValue_AsciiVal{x}
		return true, err
	case 13: // value.proto_bytes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &TypedValue_ProtoBytes{x}
		return true, err
	default:
		return false, nil
	}
}

func _TypedValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TypedValue)
	// value
	switch x := m.Value.(type) {
	case *TypedValue_StringVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringVal)))
		n += len(x.StringVal)
	case *TypedValue_IntVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IntVal))
	case *TypedValue_UintVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.UintVal))
	case *TypedValue_BoolVal:
		n += 1 // tag and wire
		n += 1
	case *TypedValue_BytesVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BytesVal)))
		n += len(x.BytesVal)
	case *TypedValue_FloatVal:
		n += 1 // tag and wire
		n += 4
	case *TypedValue_DecimalVal:
		s := proto.Size(x.DecimalVal)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TypedValue_LeaflistVal:
		s := proto.Size(x.LeaflistVal)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TypedValue_AnyVal:
		s := proto.Size(x.AnyVal)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TypedValue_JsonVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.JsonVal)))
		n += len(x.JsonVal)
	case *TypedValue_JsonIetfVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.JsonIetfVal)))
		n += len(x.JsonIetfVal)
	case *TypedValue_AsciiVal:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.AsciiVal)))
		n += len(x.AsciiVal)
	case *TypedValue_ProtoBytes:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ProtoBytes)))
		n += len(x.ProtoBytes)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Path encodes a data tree path as a series of repeated strings, with
// each element of the path representing a data tree node name and the
// associated attributes.
// Reference: gNMI Specification Section 2.2.2.
type Path struct {
	// Elements of the path are no longer encoded as a string, but rather within
	// the elem field as a PathElem message.
	Element              []string    `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"` // Deprecated: Do not use.
	Origin               string      `protobuf:"bytes,2,opt,name=origin,proto3" json:"origin,omitempty"`
	Elem                 []*PathElem `protobuf:"bytes,3,rep,name=elem,proto3" json:"elem,omitempty"`
	Target               string      `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Path) Reset()         { *m = Path{} }
func (m *Path) String() string { return proto.CompactTextString(m) }
func (*Path) ProtoMessage()    {}
func (*Path) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{3}
}
func (m *Path) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Path.Unmarshal(m, b)
}
func (m *Path) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Path.Marshal(b, m, deterministic)
}
func (dst *Path) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Path.Merge(dst, src)
}
func (m *Path) XXX_Size() int {
	return xxx_messageInfo_Path.Size(m)
}
func (m *Path) XXX_DiscardUnknown() {
	xxx_messageInfo_Path.DiscardUnknown(m)
}

var xxx_messageInfo_Path proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *Path) GetElement() []string {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *Path) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *Path) GetElem() []*PathElem {
	if m != nil {
		return m.Elem
	}
	return nil
}

func (m *Path) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

// PathElem encodes an element of a gNMI path, along ith any attributes (keys)
// that may be associated with it.
// Reference: gNMI Specification Section 2.2.2.
type PathElem struct {
	Name                 string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Key                  map[string]string `protobuf:"bytes,2,rep,name=key,proto3" json:"key,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PathElem) Reset()         { *m = PathElem{} }
func (m *PathElem) String() string { return proto.CompactTextString(m) }
func (*PathElem) ProtoMessage()    {}
func (*PathElem) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{4}
}
func (m *PathElem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PathElem.Unmarshal(m, b)
}
func (m *PathElem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PathElem.Marshal(b, m, deterministic)
}
func (dst *PathElem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PathElem.Merge(dst, src)
}
func (m *PathElem) XXX_Size() int {
	return xxx_messageInfo_PathElem.Size(m)
}
func (m *PathElem) XXX_DiscardUnknown() {
	xxx_messageInfo_PathElem.DiscardUnknown(m)
}

var xxx_messageInfo_PathElem proto.InternalMessageInfo

func (m *PathElem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PathElem) GetKey() map[string]string {
	if m != nil {
		return m.Key
	}
	return nil
}

// Value encodes a data tree node's value - along with the way in which
// the value is encoded. This message is deprecated by gNMI 0.3.0.
// Reference: gNMI Specification Section 2.2.3.
//
// Deprecated: Do not use.
type Value struct {
	Value                []byte   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type                 Encoding `protobuf:"varint,2,opt,name=type,proto3,enum=gnmi.Encoding" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()    {}
func (*Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{5}
}
func (m *Value) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Value.Unmarshal(m, b)
}
func (m *Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Value.Marshal(b, m, deterministic)
}
func (dst *Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value.Merge(dst, src)
}
func (m *Value) XXX_Size() int {
	return xxx_messageInfo_Value.Size(m)
}
func (m *Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Value proto.InternalMessageInfo

func (m *Value) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Value) GetType() Encoding {
	if m != nil {
		return m.Type
	}
	return Encoding_JSON
}

// Error message previously utilised to return errors to the client. Deprecated
// in favour of using the google.golang.org/genproto/googleapis/rpc/status
// message in the RPC response.
// Reference: gNMI Specification Section 2.5
//
// Deprecated: Do not use.
type Error struct {
	Code                 uint32   `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Data                 *any.Any `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{6}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Error.Unmarshal(m, b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Error.Marshal(b, m, deterministic)
}
func (dst *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(dst, src)
}
func (m *Error) XXX_Size() int {
	return xxx_messageInfo_Error.Size(m)
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

func (m *Error) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Error) GetData() *any.Any {
	if m != nil {
		return m.Data
	}
	return nil
}

// Decimal64 is used to encode a fixed precision decimal number. The value
// is expressed as a set of digits with the precision specifying the
// number of digits following the decimal point in the digit set.
type Decimal64 struct {
	Digits               int64    `protobuf:"varint,1,opt,name=digits,proto3" json:"digits,omitempty"`
	Precision            uint32   `protobuf:"varint,2,opt,name=precision,proto3" json:"precision,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Decimal64) Reset()         { *m = Decimal64{} }
func (m *Decimal64) String() string { return proto.CompactTextString(m) }
func (*Decimal64) ProtoMessage()    {}
func (*Decimal64) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{7}
}
func (m *Decimal64) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Decimal64.Unmarshal(m, b)
}
func (m *Decimal64) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Decimal64.Marshal(b, m, deterministic)
}
func (dst *Decimal64) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decimal64.Merge(dst, src)
}
func (m *Decimal64) XXX_Size() int {
	return xxx_messageInfo_Decimal64.Size(m)
}
func (m *Decimal64) XXX_DiscardUnknown() {
	xxx_messageInfo_Decimal64.DiscardUnknown(m)
}

var xxx_messageInfo_Decimal64 proto.InternalMessageInfo

func (m *Decimal64) GetDigits() int64 {
	if m != nil {
		return m.Digits
	}
	return 0
}

func (m *Decimal64) GetPrecision() uint32 {
	if m != nil {
		return m.Precision
	}
	return 0
}

// ScalarArray is used to encode a mixed-type array of values.
type ScalarArray struct {
	// The set of elements within the array. Each TypedValue message should
	// specify only elements that have a field identifier of 1-7 (i.e., the
	// values are scalar values).
	Element              []*TypedValue `protobuf:"bytes,1,rep,name=element,proto3" json:"element,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ScalarArray) Reset()         { *m = ScalarArray{} }
func (m *ScalarArray) String() string { return proto.CompactTextString(m) }
func (*ScalarArray) ProtoMessage()    {}
func (*ScalarArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{8}
}
func (m *ScalarArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalarArray.Unmarshal(m, b)
}
func (m *ScalarArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalarArray.Marshal(b, m, deterministic)
}
func (dst *ScalarArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarArray.Merge(dst, src)
}
func (m *ScalarArray) XXX_Size() int {
	return xxx_messageInfo_ScalarArray.Size(m)
}
func (m *ScalarArray) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarArray.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarArray proto.InternalMessageInfo

func (m *ScalarArray) GetElement() []*TypedValue {
	if m != nil {
		return m.Element
	}
	return nil
}

// SubscribeRequest is the message sent by the client to the target when
// initiating a subscription to a set of paths within the data tree. The
// request field must be populated and the initial message must specify a
// SubscriptionList to initiate a subscription. The message is subsequently
// used to define aliases or trigger polled data to be sent by the target.
// Reference: gNMI Specification Section 3.5.1.1
type SubscribeRequest struct {
	// Types that are valid to be assigned to Request:
	//	*SubscribeRequest_Subscribe
	//	*SubscribeRequest_Poll
	//	*SubscribeRequest_Aliases
	Request isSubscribeRequest_Request `protobuf_oneof:"request"`
	// Extension messages associated with the SubscribeRequest. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SubscribeRequest) Reset()         { *m = SubscribeRequest{} }
func (m *SubscribeRequest) String() string { return proto.CompactTextString(m) }
func (*SubscribeRequest) ProtoMessage()    {}
func (*SubscribeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{9}
}
func (m *SubscribeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubscribeRequest.Unmarshal(m, b)
}
func (m *SubscribeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubscribeRequest.Marshal(b, m, deterministic)
}
func (dst *SubscribeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubscribeRequest.Merge(dst, src)
}
func (m *SubscribeRequest) XXX_Size() int {
	return xxx_messageInfo_SubscribeRequest.Size(m)
}
func (m *SubscribeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SubscribeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SubscribeRequest proto.InternalMessageInfo

type isSubscribeRequest_Request interface {
	isSubscribeRequest_Request()
}

type SubscribeRequest_Subscribe struct {
	Subscribe *SubscriptionList `protobuf:"bytes,1,opt,name=subscribe,proto3,oneof"`
}

type SubscribeRequest_Poll struct {
	Poll *Poll `protobuf:"bytes,3,opt,name=poll,proto3,oneof"`
}

type SubscribeRequest_Aliases struct {
	Aliases *AliasList `protobuf:"bytes,4,opt,name=aliases,proto3,oneof"`
}

func (*SubscribeRequest_Subscribe) isSubscribeRequest_Request() {}

func (*SubscribeRequest_Poll) isSubscribeRequest_Request() {}

func (*SubscribeRequest_Aliases) isSubscribeRequest_Request() {}

func (m *SubscribeRequest) GetRequest() isSubscribeRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *SubscribeRequest) GetSubscribe() *SubscriptionList {
	if x, ok := m.GetRequest().(*SubscribeRequest_Subscribe); ok {
		return x.Subscribe
	}
	return nil
}

func (m *SubscribeRequest) GetPoll() *Poll {
	if x, ok := m.GetRequest().(*SubscribeRequest_Poll); ok {
		return x.Poll
	}
	return nil
}

func (m *SubscribeRequest) GetAliases() *AliasList {
	if x, ok := m.GetRequest().(*SubscribeRequest_Aliases); ok {
		return x.Aliases
	}
	return nil
}

func (m *SubscribeRequest) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SubscribeRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SubscribeRequest_OneofMarshaler, _SubscribeRequest_OneofUnmarshaler, _SubscribeRequest_OneofSizer, []interface{}{
		(*SubscribeRequest_Subscribe)(nil),
		(*SubscribeRequest_Poll)(nil),
		(*SubscribeRequest_Aliases)(nil),
	}
}

func _SubscribeRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SubscribeRequest)
	// request
	switch x := m.Request.(type) {
	case *SubscribeRequest_Subscribe:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subscribe); err != nil {
			return err
		}
	case *SubscribeRequest_Poll:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Poll); err != nil {
			return err
		}
	case *SubscribeRequest_Aliases:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Aliases); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SubscribeRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _SubscribeRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SubscribeRequest)
	switch tag {
	case 1: // request.subscribe
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubscriptionList)
		err := b.DecodeMessage(msg)
		m.Request = &SubscribeRequest_Subscribe{msg}
		return true, err
	case 3: // request.poll
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Poll)
		err := b.DecodeMessage(msg)
		m.Request = &SubscribeRequest_Poll{msg}
		return true, err
	case 4: // request.aliases
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AliasList)
		err := b.DecodeMessage(msg)
		m.Request = &SubscribeRequest_Aliases{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SubscribeRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SubscribeRequest)
	// request
	switch x := m.Request.(type) {
	case *SubscribeRequest_Subscribe:
		s := proto.Size(x.Subscribe)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SubscribeRequest_Poll:
		s := proto.Size(x.Poll)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SubscribeRequest_Aliases:
		s := proto.Size(x.Aliases)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Poll is sent within a SubscribeRequest to trigger the device to
// send telemetry updates for the paths that are associated with the
// subscription.
// Reference: gNMI Specification Section Section 3.5.1.4
type Poll struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Poll) Reset()         { *m = Poll{} }
func (m *Poll) String() string { return proto.CompactTextString(m) }
func (*Poll) ProtoMessage()    {}
func (*Poll) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{10}
}
func (m *Poll) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll.Unmarshal(m, b)
}
func (m *Poll) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll.Marshal(b, m, deterministic)
}
func (dst *Poll) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll.Merge(dst, src)
}
func (m *Poll) XXX_Size() int {
	return xxx_messageInfo_Poll.Size(m)
}
func (m *Poll) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll.DiscardUnknown(m)
}

var xxx_messageInfo_Poll proto.InternalMessageInfo

// SubscribeResponse is the message used by the target within a Subscribe RPC.
// The target includes a Notification message which is used to transmit values
// of the path(s) that are associated with the subscription. The same message
// is to indicate that the target has sent all data values once (is
// synchronized).
// Reference: gNMI Specification Section 3.5.1.4
type SubscribeResponse struct {
	// Types that are valid to be assigned to Response:
	//	*SubscribeResponse_Update
	//	*SubscribeResponse_SyncResponse
	//	*SubscribeResponse_Error
	Response isSubscribeResponse_Response `protobuf_oneof:"response"`
	// Extension messages associated with the SubscribeResponse. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SubscribeResponse) Reset()         { *m = SubscribeResponse{} }
func (m *SubscribeResponse) String() string { return proto.CompactTextString(m) }
func (*SubscribeResponse) ProtoMessage()    {}
func (*SubscribeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{11}
}
func (m *SubscribeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubscribeResponse.Unmarshal(m, b)
}
func (m *SubscribeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubscribeResponse.Marshal(b, m, deterministic)
}
func (dst *SubscribeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubscribeResponse.Merge(dst, src)
}
func (m *SubscribeResponse) XXX_Size() int {
	return xxx_messageInfo_SubscribeResponse.Size(m)
}
func (m *SubscribeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SubscribeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SubscribeResponse proto.InternalMessageInfo

type isSubscribeResponse_Response interface {
	isSubscribeResponse_Response()
}

type SubscribeResponse_Update struct {
	Update *Notification `protobuf:"bytes,1,opt,name=update,proto3,oneof"`
}

type SubscribeResponse_SyncResponse struct {
	SyncResponse bool `protobuf:"varint,3,opt,name=sync_response,json=syncResponse,proto3,oneof"`
}

type SubscribeResponse_Error struct {
	Error *Error `protobuf:"bytes,4,opt,name=error,proto3,oneof"`
}

func (*SubscribeResponse_Update) isSubscribeResponse_Response() {}

func (*SubscribeResponse_SyncResponse) isSubscribeResponse_Response() {}

func (*SubscribeResponse_Error) isSubscribeResponse_Response() {}

func (m *SubscribeResponse) GetResponse() isSubscribeResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *SubscribeResponse) GetUpdate() *Notification {
	if x, ok := m.GetResponse().(*SubscribeResponse_Update); ok {
		return x.Update
	}
	return nil
}

func (m *SubscribeResponse) GetSyncResponse() bool {
	if x, ok := m.GetResponse().(*SubscribeResponse_SyncResponse); ok {
		return x.SyncResponse
	}
	return false
}

func (m *SubscribeResponse) GetError() *Error {
	if x, ok := m.GetResponse().(*SubscribeResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (m *SubscribeResponse) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SubscribeResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SubscribeResponse_OneofMarshaler, _SubscribeResponse_OneofUnmarshaler, _SubscribeResponse_OneofSizer, []interface{}{
		(*SubscribeResponse_Update)(nil),
		(*SubscribeResponse_SyncResponse)(nil),
		(*SubscribeResponse_Error)(nil),
	}
}

func _SubscribeResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SubscribeResponse)
	// response
	switch x := m.Response.(type) {
	case *SubscribeResponse_Update:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *SubscribeResponse_SyncResponse:
		t := uint64(0)
		if x.SyncResponse {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *SubscribeResponse_Error:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SubscribeResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _SubscribeResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SubscribeResponse)
	switch tag {
	case 1: // response.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Notification)
		err := b.DecodeMessage(msg)
		m.Response = &SubscribeResponse_Update{msg}
		return true, err
	case 3: // response.sync_response
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Response = &SubscribeResponse_SyncResponse{x != 0}
		return true, err
	case 4: // response.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Error)
		err := b.DecodeMessage(msg)
		m.Response = &SubscribeResponse_Error{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SubscribeResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SubscribeResponse)
	// response
	switch x := m.Response.(type) {
	case *SubscribeResponse_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SubscribeResponse_SyncResponse:
		n += 1 // tag and wire
		n += 1
	case *SubscribeResponse_Error:
		s := proto.Size(x.Error)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// SubscriptionList is used within a Subscribe message to specify the list of
// paths that the client wishes to subscribe to. The message consists of a
// list of (possibly prefixed) paths, and options that relate to the
// subscription.
// Reference: gNMI Specification Section 3.5.1.2
type SubscriptionList struct {
	Prefix       *Path           `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Subscription []*Subscription `protobuf:"bytes,2,rep,name=subscription,proto3" json:"subscription,omitempty"`
	// Whether target defined aliases are allowed within the subscription.
	UseAliases bool                  `protobuf:"varint,3,opt,name=use_aliases,json=useAliases,proto3" json:"use_aliases,omitempty"`
	Qos        *QOSMarking           `protobuf:"bytes,4,opt,name=qos,proto3" json:"qos,omitempty"`
	Mode       SubscriptionList_Mode `protobuf:"varint,5,opt,name=mode,proto3,enum=gnmi.SubscriptionList_Mode" json:"mode,omitempty"`
	// Whether elements of the schema that are marked as eligible for aggregation
	// should be aggregated or not.
	AllowAggregation bool `protobuf:"varint,6,opt,name=allow_aggregation,json=allowAggregation,proto3" json:"allow_aggregation,omitempty"`
	// The set of schemas that define the elements of the data tree that should
	// be sent by the target.
	UseModels []*ModelData `protobuf:"bytes,7,rep,name=use_models,json=useModels,proto3" json:"use_models,omitempty"`
	// The encoding that the target should use within the Notifications generated
	// corresponding to the SubscriptionList.
	Encoding Encoding `protobuf:"varint,8,opt,name=encoding,proto3,enum=gnmi.Encoding" json:"encoding,omitempty"`
	// An optional field to specify that only updates to current state should be
	// sent to a client. If set, the initial state is not sent to the client but
	// rather only the sync message followed by any subsequent updates to the
	// current state. For ONCE and POLL modes, this causes the server to send only
	// the sync message (Sec. 3.5.2.3).
	UpdatesOnly          bool     `protobuf:"varint,9,opt,name=updates_only,json=updatesOnly,proto3" json:"updates_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SubscriptionList) Reset()         { *m = SubscriptionList{} }
func (m *SubscriptionList) String() string { return proto.CompactTextString(m) }
func (*SubscriptionList) ProtoMessage()    {}
func (*SubscriptionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{12}
}
func (m *SubscriptionList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubscriptionList.Unmarshal(m, b)
}
func (m *SubscriptionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubscriptionList.Marshal(b, m, deterministic)
}
func (dst *SubscriptionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubscriptionList.Merge(dst, src)
}
func (m *SubscriptionList) XXX_Size() int {
	return xxx_messageInfo_SubscriptionList.Size(m)
}
func (m *SubscriptionList) XXX_DiscardUnknown() {
	xxx_messageInfo_SubscriptionList.DiscardUnknown(m)
}

var xxx_messageInfo_SubscriptionList proto.InternalMessageInfo

func (m *SubscriptionList) GetPrefix() *Path {
	if m != nil {
		return m.Prefix
	}
	return nil
}

func (m *SubscriptionList) GetSubscription() []*Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *SubscriptionList) GetUseAliases() bool {
	if m != nil {
		return m.UseAliases
	}
	return false
}

func (m *SubscriptionList) GetQos() *QOSMarking {
	if m != nil {
		return m.Qos
	}
	return nil
}

func (m *SubscriptionList) GetMode() SubscriptionList_Mode {
	if m != nil {
		return m.Mode
	}
	return SubscriptionList_STREAM
}

func (m *SubscriptionList) GetAllowAggregation() bool {
	if m != nil {
		return m.AllowAggregation
	}
	return false
}

func (m *SubscriptionList) GetUseModels() []*ModelData {
	if m != nil {
		return m.UseModels
	}
	return nil
}

func (m *SubscriptionList) GetEncoding() Encoding {
	if m != nil {
		return m.Encoding
	}
	return Encoding_JSON
}

func (m *SubscriptionList) GetUpdatesOnly() bool {
	if m != nil {
		return m.UpdatesOnly
	}
	return false
}

// Subscription is a single request within a SubscriptionList. The path
// specified is interpreted (along with the prefix) as the elements of the data
// tree that the client is subscribing to. The mode determines how the target
// should trigger updates to be sent.
// Reference: gNMI Specification Section 3.5.1.3
type Subscription struct {
	Path           *Path            `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Mode           SubscriptionMode `protobuf:"varint,2,opt,name=mode,proto3,enum=gnmi.SubscriptionMode" json:"mode,omitempty"`
	SampleInterval uint64           `protobuf:"varint,3,opt,name=sample_interval,json=sampleInterval,proto3" json:"sample_interval,omitempty"`
	// Indicates whether values that not changed should be sent in a SAMPLE
	// subscription.
	SuppressRedundant bool `protobuf:"varint,4,opt,name=suppress_redundant,json=suppressRedundant,proto3" json:"suppress_redundant,omitempty"`
	// Specifies the maximum allowable silent period in nanoseconds when
	// suppress_redundant is in use. The target should send a value at least once
	// in the period specified.
	HeartbeatInterval    uint64   `protobuf:"varint,5,opt,name=heartbeat_interval,json=heartbeatInterval,proto3" json:"heartbeat_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{13}
}
func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (dst *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(dst, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetPath() *Path {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Subscription) GetMode() SubscriptionMode {
	if m != nil {
		return m.Mode
	}
	return SubscriptionMode_TARGET_DEFINED
}

func (m *Subscription) GetSampleInterval() uint64 {
	if m != nil {
		return m.SampleInterval
	}
	return 0
}

func (m *Subscription) GetSuppressRedundant() bool {
	if m != nil {
		return m.SuppressRedundant
	}
	return false
}

func (m *Subscription) GetHeartbeatInterval() uint64 {
	if m != nil {
		return m.HeartbeatInterval
	}
	return 0
}

// QOSMarking specifies the DSCP value to be set on transmitted telemetry
// updates from the target.
// Reference: gNMI Specification Section 3.5.1.2
type QOSMarking struct {
	Marking              uint32   `protobuf:"varint,1,opt,name=marking,proto3" json:"marking,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QOSMarking) Reset()         { *m = QOSMarking{} }
func (m *QOSMarking) String() string { return proto.CompactTextString(m) }
func (*QOSMarking) ProtoMessage()    {}
func (*QOSMarking) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{14}
}
func (m *QOSMarking) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QOSMarking.Unmarshal(m, b)
}
func (m *QOSMarking) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QOSMarking.Marshal(b, m, deterministic)
}
func (dst *QOSMarking) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QOSMarking.Merge(dst, src)
}
func (m *QOSMarking) XXX_Size() int {
	return xxx_messageInfo_QOSMarking.Size(m)
}
func (m *QOSMarking) XXX_DiscardUnknown() {
	xxx_messageInfo_QOSMarking.DiscardUnknown(m)
}

var xxx_messageInfo_QOSMarking proto.InternalMessageInfo

func (m *QOSMarking) GetMarking() uint32 {
	if m != nil {
		return m.Marking
	}
	return 0
}

// Alias specifies a data tree path, and an associated string which defines an
// alias which is to be used for this path in the context of the RPC. The alias
// is specified as a string which is prefixed with "#" to disambiguate it from
// data tree element paths.
// Reference: gNMI Specification Section 2.4.2
type Alias struct {
	Path                 *Path    `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Alias                string   `protobuf:"bytes,2,opt,name=alias,proto3" json:"alias,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Alias) Reset()         { *m = Alias{} }
func (m *Alias) String() string { return proto.CompactTextString(m) }
func (*Alias) ProtoMessage()    {}
func (*Alias) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{15}
}
func (m *Alias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Alias.Unmarshal(m, b)
}
func (m *Alias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Alias.Marshal(b, m, deterministic)
}
func (dst *Alias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alias.Merge(dst, src)
}
func (m *Alias) XXX_Size() int {
	return xxx_messageInfo_Alias.Size(m)
}
func (m *Alias) XXX_DiscardUnknown() {
	xxx_messageInfo_Alias.DiscardUnknown(m)
}

var xxx_messageInfo_Alias proto.InternalMessageInfo

func (m *Alias) GetPath() *Path {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Alias) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

// AliasList specifies a list of aliases. It is used in a SubscribeRequest for
// a client to create a set of aliases that the target is to utilize.
// Reference: gNMI Specification Section 3.5.1.6
type AliasList struct {
	Alias                []*Alias `protobuf:"bytes,1,rep,name=alias,proto3" json:"alias,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AliasList) Reset()         { *m = AliasList{} }
func (m *AliasList) String() string { return proto.CompactTextString(m) }
func (*AliasList) ProtoMessage()    {}
func (*AliasList) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{16}
}
func (m *AliasList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AliasList.Unmarshal(m, b)
}
func (m *AliasList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AliasList.Marshal(b, m, deterministic)
}
func (dst *AliasList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AliasList.Merge(dst, src)
}
func (m *AliasList) XXX_Size() int {
	return xxx_messageInfo_AliasList.Size(m)
}
func (m *AliasList) XXX_DiscardUnknown() {
	xxx_messageInfo_AliasList.DiscardUnknown(m)
}

var xxx_messageInfo_AliasList proto.InternalMessageInfo

func (m *AliasList) GetAlias() []*Alias {
	if m != nil {
		return m.Alias
	}
	return nil
}

// SetRequest is sent from a client to the target to update values in the data
// tree. Paths are either deleted by the client, or modified by means of being
// updated, or replaced. Where a replace is used, unspecified values are
// considered to be replaced, whereas when update is used the changes are
// considered to be incremental. The set of changes that are specified within
// a single SetRequest are considered to be a transaction.
// Reference: gNMI Specification Section 3.4.1
type SetRequest struct {
	Prefix  *Path     `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Delete  []*Path   `protobuf:"bytes,2,rep,name=delete,proto3" json:"delete,omitempty"`
	Replace []*Update `protobuf:"bytes,3,rep,name=replace,proto3" json:"replace,omitempty"`
	Update  []*Update `protobuf:"bytes,4,rep,name=update,proto3" json:"update,omitempty"`
	// Extension messages associated with the SetRequest. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SetRequest) Reset()         { *m = SetRequest{} }
func (m *SetRequest) String() string { return proto.CompactTextString(m) }
func (*SetRequest) ProtoMessage()    {}
func (*SetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{17}
}
func (m *SetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetRequest.Unmarshal(m, b)
}
func (m *SetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetRequest.Marshal(b, m, deterministic)
}
func (dst *SetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetRequest.Merge(dst, src)
}
func (m *SetRequest) XXX_Size() int {
	return xxx_messageInfo_SetRequest.Size(m)
}
func (m *SetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetRequest proto.InternalMessageInfo

func (m *SetRequest) GetPrefix() *Path {
	if m != nil {
		return m.Prefix
	}
	return nil
}

func (m *SetRequest) GetDelete() []*Path {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *SetRequest) GetReplace() []*Update {
	if m != nil {
		return m.Replace
	}
	return nil
}

func (m *SetRequest) GetUpdate() []*Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *SetRequest) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// SetResponse is the response to a SetRequest, sent from the target to the
// client. It reports the result of the modifications to the data tree that were
// specified by the client. Errors for this RPC should be reported using the
// https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto
// message in the RPC return. The gnmi.Error message can be used to add additional
// details where required.
// Reference: gNMI Specification Section 3.4.2
type SetResponse struct {
	Prefix *Path `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// A set of responses specifying the result of the operations specified in
	// the SetRequest.
	Response  []*UpdateResult `protobuf:"bytes,2,rep,name=response,proto3" json:"response,omitempty"`
	Message   *Error          `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"` // Deprecated: Do not use.
	Timestamp int64           `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Extension messages associated with the SetResponse. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,5,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SetResponse) Reset()         { *m = SetResponse{} }
func (m *SetResponse) String() string { return proto.CompactTextString(m) }
func (*SetResponse) ProtoMessage()    {}
func (*SetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{18}
}
func (m *SetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetResponse.Unmarshal(m, b)
}
func (m *SetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetResponse.Marshal(b, m, deterministic)
}
func (dst *SetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetResponse.Merge(dst, src)
}
func (m *SetResponse) XXX_Size() int {
	return xxx_messageInfo_SetResponse.Size(m)
}
func (m *SetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SetResponse proto.InternalMessageInfo

func (m *SetResponse) GetPrefix() *Path {
	if m != nil {
		return m.Prefix
	}
	return nil
}

func (m *SetResponse) GetResponse() []*UpdateResult {
	if m != nil {
		return m.Response
	}
	return nil
}

// Deprecated: Do not use.
func (m *SetResponse) GetMessage() *Error {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *SetResponse) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *SetResponse) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// UpdateResult is used within the SetResponse message to communicate the
// result of an operation specified within a SetRequest message.
// Reference: gNMI Specification Section 3.4.2
type UpdateResult struct {
	// Deprecated timestamp for the UpdateResult, this field has been
	// replaced by the timestamp within the SetResponse message, since
	// all mutations effected by a set should be applied as a single
	// transaction.
	Timestamp            int64                  `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"` // Deprecated: Do not use.
	Path                 *Path                  `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Message              *Error                 `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"` // Deprecated: Do not use.
	Op                   UpdateResult_Operation `protobuf:"varint,4,opt,name=op,proto3,enum=gnmi.UpdateResult_Operation" json:"op,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *UpdateResult) Reset()         { *m = UpdateResult{} }
func (m *UpdateResult) String() string { return proto.CompactTextString(m) }
func (*UpdateResult) ProtoMessage()    {}
func (*UpdateResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{19}
}
func (m *UpdateResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateResult.Unmarshal(m, b)
}
func (m *UpdateResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateResult.Marshal(b, m, deterministic)
}
func (dst *UpdateResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateResult.Merge(dst, src)
}
func (m *UpdateResult) XXX_Size() int {
	return xxx_messageInfo_UpdateResult.Size(m)
}
func (m *UpdateResult) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateResult.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateResult proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *UpdateResult) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *UpdateResult) GetPath() *Path {
	if m != nil {
		return m.Path
	}
	return nil
}

// Deprecated: Do not use.
func (m *UpdateResult) GetMessage() *Error {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UpdateResult) GetOp() UpdateResult_Operation {
	if m != nil {
		return m.Op
	}
	return UpdateResult_INVALID
}

// GetRequest is sent when a client initiates a Get RPC. It is used to specify
// the set of data elements for which the target should return a snapshot of
// data. The use_models field specifies the set of schema modules that are to
// be used by the target - where use_models is not specified then the target
// must use all schema models that it has.
// Reference: gNMI Specification Section 3.3.1
type GetRequest struct {
	Prefix    *Path               `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Path      []*Path             `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
	Type      GetRequest_DataType `protobuf:"varint,3,opt,name=type,proto3,enum=gnmi.GetRequest_DataType" json:"type,omitempty"`
	Encoding  Encoding            `protobuf:"varint,5,opt,name=encoding,proto3,enum=gnmi.Encoding" json:"encoding,omitempty"`
	UseModels []*ModelData        `protobuf:"bytes,6,rep,name=use_models,json=useModels,proto3" json:"use_models,omitempty"`
	// Extension messages associated with the GetRequest. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,7,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetRequest) Reset()         { *m = GetRequest{} }
func (m *GetRequest) String() string { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()    {}
func (*GetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{20}
}
func (m *GetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRequest.Unmarshal(m, b)
}
func (m *GetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRequest.Marshal(b, m, deterministic)
}
func (dst *GetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRequest.Merge(dst, src)
}
func (m *GetRequest) XXX_Size() int {
	return xxx_messageInfo_GetRequest.Size(m)
}
func (m *GetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRequest proto.InternalMessageInfo

func (m *GetRequest) GetPrefix() *Path {
	if m != nil {
		return m.Prefix
	}
	return nil
}

func (m *GetRequest) GetPath() []*Path {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *GetRequest) GetType() GetRequest_DataType {
	if m != nil {
		return m.Type
	}
	return GetRequest_ALL
}

func (m *GetRequest) GetEncoding() Encoding {
	if m != nil {
		return m.Encoding
	}
	return Encoding_JSON
}

func (m *GetRequest) GetUseModels() []*ModelData {
	if m != nil {
		return m.UseModels
	}
	return nil
}

func (m *GetRequest) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// GetResponse is used by the target to respond to a GetRequest from a client.
// The set of Notifications corresponds to the data values that are requested
// by the client in the GetRequest.
// Reference: gNMI Specification Section 3.3.2
type GetResponse struct {
	Notification []*Notification `protobuf:"bytes,1,rep,name=notification,proto3" json:"notification,omitempty"`
	Error        *Error          `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"` // Deprecated: Do not use.
	// Extension messages associated with the GetResponse. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,3,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetResponse) Reset()         { *m = GetResponse{} }
func (m *GetResponse) String() string { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()    {}
func (*GetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{21}
}
func (m *GetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetResponse.Unmarshal(m, b)
}
func (m *GetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetResponse.Marshal(b, m, deterministic)
}
func (dst *GetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetResponse.Merge(dst, src)
}
func (m *GetResponse) XXX_Size() int {
	return xxx_messageInfo_GetResponse.Size(m)
}
func (m *GetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetResponse proto.InternalMessageInfo

func (m *GetResponse) GetNotification() []*Notification {
	if m != nil {
		return m.Notification
	}
	return nil
}

// Deprecated: Do not use.
func (m *GetResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *GetResponse) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// CapabilityRequest is sent by the client in the Capabilities RPC to request
// that the target reports its capabilities.
// Reference: gNMI Specification Section 3.2.1
type CapabilityRequest struct {
	// Extension messages associated with the CapabilityRequest. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,1,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CapabilityRequest) Reset()         { *m = CapabilityRequest{} }
func (m *CapabilityRequest) String() string { return proto.CompactTextString(m) }
func (*CapabilityRequest) ProtoMessage()    {}
func (*CapabilityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{22}
}
func (m *CapabilityRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapabilityRequest.Unmarshal(m, b)
}
func (m *CapabilityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapabilityRequest.Marshal(b, m, deterministic)
}
func (dst *CapabilityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapabilityRequest.Merge(dst, src)
}
func (m *CapabilityRequest) XXX_Size() int {
	return xxx_messageInfo_CapabilityRequest.Size(m)
}
func (m *CapabilityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CapabilityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CapabilityRequest proto.InternalMessageInfo

func (m *CapabilityRequest) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// CapabilityResponse is used by the target to report its capabilities to the
// client within the Capabilities RPC.
// Reference: gNMI Specification Section 3.2.2
type CapabilityResponse struct {
	SupportedModels    []*ModelData `protobuf:"bytes,1,rep,name=supported_models,json=supportedModels,proto3" json:"supported_models,omitempty"`
	SupportedEncodings []Encoding   `protobuf:"varint,2,rep,packed,name=supported_encodings,json=supportedEncodings,proto3,enum=gnmi.Encoding" json:"supported_encodings,omitempty"`
	GNMIVersion        string       `protobuf:"bytes,3,opt,name=gNMI_version,json=gNMIVersion,proto3" json:"gNMI_version,omitempty"`
	// Extension messages associated with the CapabilityResponse. See the
	// gNMI extension specification for further definition.
	Extension            []*gnmi_ext.Extension `protobuf:"bytes,4,rep,name=extension,proto3" json:"extension,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CapabilityResponse) Reset()         { *m = CapabilityResponse{} }
func (m *CapabilityResponse) String() string { return proto.CompactTextString(m) }
func (*CapabilityResponse) ProtoMessage()    {}
func (*CapabilityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{23}
}
func (m *CapabilityResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapabilityResponse.Unmarshal(m, b)
}
func (m *CapabilityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapabilityResponse.Marshal(b, m, deterministic)
}
func (dst *CapabilityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapabilityResponse.Merge(dst, src)
}
func (m *CapabilityResponse) XXX_Size() int {
	return xxx_messageInfo_CapabilityResponse.Size(m)
}
func (m *CapabilityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CapabilityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CapabilityResponse proto.InternalMessageInfo

func (m *CapabilityResponse) GetSupportedModels() []*ModelData {
	if m != nil {
		return m.SupportedModels
	}
	return nil
}

func (m *CapabilityResponse) GetSupportedEncodings() []Encoding {
	if m != nil {
		return m.SupportedEncodings
	}
	return nil
}

func (m *CapabilityResponse) GetGNMIVersion() string {
	if m != nil {
		return m.GNMIVersion
	}
	return ""
}

func (m *CapabilityResponse) GetExtension() []*gnmi_ext.Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

// ModelData is used to describe a set of schema modules. It can be used in a
// CapabilityResponse where a target reports the set of modules that it
// supports, and within the SubscribeRequest and GetRequest messages to specify
// the set of models from which data tree elements should be reported.
// Reference: gNMI Specification Section 3.2.3
type ModelData struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Organization         string   `protobuf:"bytes,2,opt,name=organization,proto3" json:"organization,omitempty"`
	Version              string   `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModelData) Reset()         { *m = ModelData{} }
func (m *ModelData) String() string { return proto.CompactTextString(m) }
func (*ModelData) ProtoMessage()    {}
func (*ModelData) Descriptor() ([]byte, []int) {
	return fileDescriptor_gnmi_f14ad093ed8108a5, []int{24}
}
func (m *ModelData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModelData.Unmarshal(m, b)
}
func (m *ModelData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModelData.Marshal(b, m, deterministic)
}
func (dst *ModelData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModelData.Merge(dst, src)
}
func (m *ModelData) XXX_Size() int {
	return xxx_messageInfo_ModelData.Size(m)
}
func (m *ModelData) XXX_DiscardUnknown() {
	xxx_messageInfo_ModelData.DiscardUnknown(m)
}

var xxx_messageInfo_ModelData proto.InternalMessageInfo

func (m *ModelData) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModelData) GetOrganization() string {
	if m != nil {
		return m.Organization
	}
	return ""
}

func (m *ModelData) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

var E_GnmiService = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.FileOptions)(nil),
	ExtensionType: (*string)(nil),
	Field:         1001,
	Name:          "gnmi.gnmi_service",
	Tag:           "bytes,1001,opt,name=gnmi_service,json=gnmiService",
	Filename:      "proto/gnmi/gnmi.proto",
}

func init() {
	proto.RegisterType((*Notification)(nil), "gnmi.Notification")
	proto.RegisterType((*Update)(nil), "gnmi.Update")
	proto.RegisterType((*TypedValue)(nil), "gnmi.TypedValue")
	proto.RegisterType((*Path)(nil), "gnmi.Path")
	proto.RegisterType((*PathElem)(nil), "gnmi.PathElem")
	proto.RegisterMapType((map[string]string)(nil), "gnmi.PathElem.KeyEntry")
	proto.RegisterType((*Value)(nil), "gnmi.Value")
	proto.RegisterType((*Error)(nil), "gnmi.Error")
	proto.RegisterType((*Decimal64)(nil), "gnmi.Decimal64")
	proto.RegisterType((*ScalarArray)(nil), "gnmi.ScalarArray")
	proto.RegisterType((*SubscribeRequest)(nil), "gnmi.SubscribeRequest")
	proto.RegisterType((*Poll)(nil), "gnmi.Poll")
	proto.RegisterType((*SubscribeResponse)(nil), "gnmi.SubscribeResponse")
	proto.RegisterType((*SubscriptionList)(nil), "gnmi.SubscriptionList")
	proto.RegisterType((*Subscription)(nil), "gnmi.Subscription")
	proto.RegisterType((*QOSMarking)(nil), "gnmi.QOSMarking")
	proto.RegisterType((*Alias)(nil), "gnmi.Alias")
	proto.RegisterType((*AliasList)(nil), "gnmi.AliasList")
	proto.RegisterType((*SetRequest)(nil), "gnmi.SetRequest")
	proto.RegisterType((*SetResponse)(nil), "gnmi.SetResponse")
	proto.RegisterType((*UpdateResult)(nil), "gnmi.UpdateResult")
	proto.RegisterType((*GetRequest)(nil), "gnmi.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "gnmi.GetResponse")
	proto.RegisterType((*CapabilityRequest)(nil), "gnmi.CapabilityRequest")
	proto.RegisterType((*CapabilityResponse)(nil), "gnmi.CapabilityResponse")
	proto.RegisterType((*ModelData)(nil), "gnmi.ModelData")
	proto.RegisterEnum("gnmi.Encoding", Encoding_name, Encoding_value)
	proto.RegisterEnum("gnmi.SubscriptionMode", SubscriptionMode_name, SubscriptionMode_value)
	proto.RegisterEnum("gnmi.SubscriptionList_Mode", SubscriptionList_Mode_name, SubscriptionList_Mode_value)
	proto.RegisterEnum("gnmi.UpdateResult_Operation", UpdateResult_Operation_name, UpdateResult_Operation_value)
	proto.RegisterEnum("gnmi.GetRequest_DataType", GetRequest_DataType_name, GetRequest_DataType_value)
	proto.RegisterExtension(E_GnmiService)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GNMIClient is the client API for GNMI service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GNMIClient interface {
	// Capabilities allows the client to retrieve the set of capabilities that
	// is supported by the target. This allows the target to validate the
	// service version that is implemented and retrieve the set of models that
	// the target supports. The models can then be specified in subsequent RPCs
	// to restrict the set of data that is utilized.
	// Reference: gNMI Specification Section 3.2
	Capabilities(ctx context.Context, in *CapabilityRequest, opts ...grpc.CallOption) (*CapabilityResponse, error)
	// Retrieve a snapshot of data from the target. A Get RPC requests that the
	// target snapshots a subset of the data tree as specified by the paths
	// included in the message and serializes this to be returned to the
	// client using the specified encoding.
	// Reference: gNMI Specification Section 3.3
	Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error)
	// Set allows the client to modify the state of data on the target. The
	// paths to modified along with the new values that the client wishes
	// to set the value to.
	// Reference: gNMI Specification Section 3.4
	Set(ctx context.Context, in *SetRequest, opts ...grpc.CallOption) (*SetResponse, error)
	// Subscribe allows a client to request the target to send it values
	// of particular paths within the data tree. These values may be streamed
	// at a particular cadence (STREAM), sent one off on a long-lived channel
	// (POLL), or sent as a one-off retrieval (ONCE).
	// Reference: gNMI Specification Section 3.5
	Subscribe(ctx context.Context, opts ...grpc.CallOption) (GNMI_SubscribeClient, error)
}

type gNMIClient struct {
	cc *grpc.ClientConn
}

func NewGNMIClient(cc *grpc.ClientConn) GNMIClient {
	return &gNMIClient{cc}
}

func (c *gNMIClient) Capabilities(ctx context.Context, in *CapabilityRequest, opts ...grpc.CallOption) (*CapabilityResponse, error) {
	out := new(CapabilityResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Capabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error) {
	out := new(GetResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Set(ctx context.Context, in *SetRequest, opts ...grpc.CallOption) (*SetResponse, error) {
	out := new(SetResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Set", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Subscribe(ctx context.Context, opts ...grpc.CallOption) (GNMI_SubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_GNMI_serviceDesc.Streams[0], "/gnmi.gNMI/Subscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &gNMISubscribeClient{stream}
	return x, nil
}

type GNMI_SubscribeClient interface {
	Send(*SubscribeRequest) error
	Recv() (*SubscribeResponse, error)
	grpc.ClientStream
}

type gNMISubscribeClient struct {
	grpc.ClientStream
}

func (x *gNMISubscribeClient) Send(m *SubscribeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gNMISubscribeClient) Recv() (*SubscribeResponse, error) {
	m := new(SubscribeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GNMIServer is the server API for GNMI service.
type GNMIServer interface {
	// Capabilities allows the client to retrieve the set of capabilities that
	// is supported by the target. This allows the target to validate the
	// service version that is implemented and retrieve the set of models that
	// the target supports. The models can then be specified in subsequent RPCs
	// to restrict the set of data that is utilized.
	// Reference: gNMI Specification Section 3.2
	Capabilities(context.Context, *CapabilityRequest) (*CapabilityResponse, error)
	// Retrieve a snapshot of data from the target. A Get RPC requests that the
	// target snapshots a subset of the data tree as specified by the paths
	// included in the message and serializes this to be returned to the
	// client using the specified encoding.
	// Reference: gNMI Specification Section 3.3
	Get(context.Context, *GetRequest) (*GetResponse, error)
	// Set allows the client to modify the state of data on the target. The
	// paths to modified along with the new values that the client wishes
	// to set the value to.
	// Reference: gNMI Specification Section 3.4
	Set(context.Context, *SetRequest) (*SetResponse, error)
	// Subscribe allows a client to request the target to send it values
	// of particular paths within the data tree. These values may be streamed
	// at a particular cadence (STREAM), sent one off on a long-lived channel
	// (POLL), or sent as a one-off retrieval (ONCE).
	// Reference: gNMI Specification Section 3.5
	Subscribe(GNMI_SubscribeServer) error
}

func RegisterGNMIServer(s *grpc.Server, srv GNMIServer) {
	s.RegisterService(&_GNMI_serviceDesc, srv)
}

func _GNMI_Capabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CapabilityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Capabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Capabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Capabilities(ctx, req.(*CapabilityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Get(ctx, req.(*GetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Set",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Set(ctx, req.(*SetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GNMIServer).Subscribe(&gNMISubscribeServer{stream})
}

type GNMI_SubscribeServer interface {
	Send(*SubscribeResponse) error
	Recv() (*SubscribeRequest, error)
	grpc.ServerStream
}

type gNMISubscribeServer struct {
	grpc.ServerStream
}

func (x *gNMISubscribeServer) Send(m *SubscribeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gNMISubscribeServer) Recv() (*SubscribeRequest, error) {
	m := new(SubscribeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _GNMI_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gnmi.gNMI",
	HandlerType: (*GNMIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Capabilities",
			Handler:    _GNMI_Capabilities_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GNMI_Get_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _GNMI_Set_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _GNMI_Subscribe_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "proto/gnmi/gnmi.proto",
}

func init() { proto.RegisterFile("proto/gnmi/gnmi.proto", fileDescriptor_gnmi_f14ad093ed8108a5) }

var fileDescriptor_gnmi_f14ad093ed8108a5 = []byte{
	// 1952 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x5f, 0x93, 0xe3, 0x46,
	0x11, 0xb7, 0x2c, 0xf9, 0x8f, 0x5a, 0xde, 0x3d, 0xed, 0x24, 0x24, 0xce, 0xe6, 0x48, 0x7c, 0xaa,
	0xe4, 0xe2, 0x6c, 0x12, 0xef, 0xb1, 0x50, 0x4b, 0x38, 0x2a, 0x10, 0xed, 0xae, 0x76, 0xd7, 0xe0,
	0xb5, 0x97, 0xb1, 0x73, 0x55, 0x3c, 0x50, 0xae, 0x59, 0x7b, 0xd6, 0x27, 0x22, 0x4b, 0x8a, 0x34,
	0x3e, 0xce, 0xbc, 0xf1, 0x19, 0xf8, 0x00, 0x7c, 0x0d, 0x3e, 0x02, 0x05, 0x2f, 0xbc, 0x50, 0x3c,
	0xf1, 0x40, 0xf1, 0x00, 0x14, 0x5f, 0x82, 0x9a, 0x3f, 0x92, 0xec, 0xb3, 0xaf, 0x6e, 0x2f, 0x2f,
	0x2e, 0x4d, 0xff, 0xba, 0x7b, 0xa6, 0xa7, 0x7b, 0x7e, 0xdd, 0x86, 0xef, 0xc4, 0x49, 0xc4, 0xa2,
	0xc3, 0x59, 0x38, 0xf7, 0xc5, 0x4f, 0x47, 0xac, 0x91, 0xc1, 0xbf, 0xf7, 0xdf, 0x99, 0x45, 0xd1,
	0x2c, 0xa0, 0x87, 0x42, 0x76, 0xb3, 0xb8, 0x3d, 0x24, 0xe1, 0x52, 0x2a, 0xec, 0xb7, 0x5e, 0x84,
	0xa6, 0x34, 0x9d, 0x24, 0x7e, 0xcc, 0xa2, 0x44, 0x69, 0x7c, 0x3e, 0xf3, 0xd9, 0xd3, 0xc5, 0x4d,
	0x67, 0x12, 0xcd, 0x0f, 0xa3, 0x98, 0x86, 0x93, 0x28, 0xbc, 0xf5, 0x67, 0x72, 0xa7, 0x62, 0xd3,
	0x31, 0x7d, 0xce, 0xf2, 0x0f, 0x69, 0xe9, 0xfc, 0x49, 0x83, 0x46, 0x3f, 0x62, 0xfe, 0xad, 0x3f,
	0x21, 0xcc, 0x8f, 0x42, 0x74, 0x1f, 0x4c, 0xe6, 0xcf, 0x69, 0xca, 0xc8, 0x3c, 0x6e, 0x6a, 0x2d,
	0xad, 0xad, 0xe3, 0x42, 0x80, 0x1c, 0xa8, 0xc6, 0x09, 0xbd, 0xf5, 0x9f, 0x37, 0xcb, 0x2d, 0xad,
	0x6d, 0x1d, 0x41, 0x47, 0x04, 0x72, 0x4d, 0xd8, 0x53, 0xac, 0x10, 0xf4, 0x26, 0x54, 0x48, 0xe0,
	0x93, 0xb4, 0xa9, 0xb7, 0xb4, 0xb6, 0x89, 0xe5, 0x02, 0x7d, 0x00, 0xd5, 0x45, 0x3c, 0x25, 0x8c,
	0x36, 0x8d, 0x96, 0xde, 0xb6, 0x8e, 0x1a, 0xd2, 0xf2, 0x2b, 0x21, 0xc3, 0x0a, 0xe3, 0xfe, 0xa7,
	0x34, 0xa0, 0x8c, 0x36, 0x2b, 0x42, 0x6b, 0xcd, 0xbf, 0x44, 0xd0, 0x5b, 0x50, 0x25, 0x2c, 0x9a,
	0xfb, 0x93, 0x66, 0xb5, 0xa5, 0xb5, 0xeb, 0x58, 0xad, 0x9c, 0xdf, 0x6b, 0x50, 0x95, 0xee, 0xd0,
	0x7b, 0x60, 0xc4, 0x84, 0x3d, 0x15, 0xe7, 0x5f, 0x77, 0x22, 0xe4, 0xe8, 0x43, 0xa8, 0x3c, 0x23,
	0xc1, 0x82, 0xaa, 0x28, 0x2c, 0xa9, 0xf0, 0x84, 0x8b, 0x4e, 0xca, 0x4d, 0x0d, 0x4b, 0x14, 0x39,
	0xa0, 0x3f, 0x23, 0x81, 0x88, 0xc3, 0x3a, 0xb2, 0xa5, 0xd2, 0x68, 0x19, 0xd3, 0xa9, 0xd0, 0xc4,
	0x1c, 0x44, 0xef, 0x01, 0x4c, 0x17, 0x71, 0xc0, 0xaf, 0x8f, 0xa6, 0x4d, 0xa3, 0xa5, 0xb5, 0x77,
	0xf0, 0x8a, 0xc4, 0xf9, 0x9f, 0x0e, 0x50, 0xd8, 0xa0, 0xf7, 0x01, 0x52, 0x96, 0xf8, 0xe1, 0x6c,
	0xcc, 0x3d, 0xf3, 0xf3, 0x99, 0x97, 0x25, 0x6c, 0x4a, 0xd9, 0x13, 0x12, 0xa0, 0x77, 0xa0, 0xe6,
	0x87, 0x4c, 0xa0, 0xfc, 0x70, 0xfa, 0x65, 0x09, 0x57, 0xfd, 0x90, 0x71, 0xe8, 0x5d, 0xa8, 0x2f,
	0x32, 0x8c, 0x9f, 0xc9, 0xb8, 0x2c, 0xe1, 0xda, 0xa2, 0x00, 0x6f, 0xa2, 0x28, 0x10, 0x20, 0x3f,
	0x45, 0x9d, 0x83, 0x5c, 0xc2, 0xc1, 0xef, 0x82, 0x79, 0xb3, 0x64, 0x34, 0x15, 0x68, 0xa5, 0xa5,
	0xb5, 0x1b, 0x97, 0x25, 0x5c, 0x17, 0x22, 0x05, 0xdf, 0x06, 0x11, 0x91, 0x9e, 0xf9, 0xa5, 0x96,
	0x39, 0x2c, 0x44, 0x1c, 0x3e, 0x02, 0x6b, 0x4a, 0x27, 0xfe, 0x9c, 0x48, 0xef, 0x35, 0x71, 0x1d,
	0xf7, 0xe4, 0x75, 0x9c, 0x49, 0xe0, 0xf8, 0x07, 0x97, 0x25, 0x0c, 0x4a, 0x8b, 0xdb, 0x1c, 0x43,
	0x23, 0xa0, 0xe4, 0x36, 0xf0, 0x53, 0xe9, 0xb5, 0x2e, 0x8c, 0xf6, 0xa4, 0xd1, 0x70, 0x42, 0x02,
	0x92, 0xb8, 0x49, 0x42, 0x96, 0x97, 0x25, 0x6c, 0x65, 0x8a, 0xdc, 0xee, 0x10, 0x6a, 0x24, 0x5c,
	0x0a, 0x13, 0x53, 0x98, 0xbc, 0xd9, 0x91, 0xd5, 0xdf, 0xc9, 0xaa, 0xbf, 0xe3, 0x86, 0xdc, 0xaa,
	0x4a, 0xc2, 0xa5, 0x8a, 0xfb, 0xd7, 0x69, 0x14, 0x0a, 0x0b, 0x50, 0x91, 0xd5, 0xb8, 0x84, 0x83,
	0x1f, 0xc0, 0x8e, 0x00, 0x7d, 0xca, 0x6e, 0x85, 0x86, 0xa5, 0x34, 0x2c, 0x2e, 0xee, 0x52, 0x76,
	0xab, 0xc2, 0x27, 0xe9, 0xc4, 0xf7, 0x85, 0x46, 0x43, 0xa5, 0xa4, 0x2e, 0x44, 0x1c, 0x7e, 0x00,
	0x96, 0xd8, 0x7b, 0x2c, 0xee, 0xab, 0xb9, 0xa3, 0x5c, 0x80, 0x10, 0x9e, 0x70, 0xd9, 0x49, 0x4d,
	0xd5, 0x93, 0xf3, 0x1c, 0x0c, 0x5e, 0x66, 0xe8, 0x3e, 0xd4, 0x68, 0x40, 0xe7, 0x34, 0x64, 0x4d,
	0xad, 0xa5, 0xb7, 0x4d, 0x51, 0x55, 0x99, 0x88, 0x57, 0x70, 0x94, 0xf8, 0x33, 0x3f, 0x14, 0x29,
	0x36, 0xb1, 0x5a, 0x21, 0x07, 0x0c, 0xae, 0xd2, 0xd4, 0x45, 0xed, 0xef, 0x16, 0x65, 0xeb, 0x05,
	0x74, 0x8e, 0x05, 0xc6, 0x6d, 0x19, 0x49, 0x66, 0x94, 0x89, 0x2c, 0x9b, 0x58, 0xad, 0x9c, 0xdf,
	0x69, 0x50, 0xcf, 0x54, 0x11, 0x02, 0x23, 0x24, 0x73, 0x2a, 0xeb, 0x0b, 0x8b, 0x6f, 0xf4, 0x31,
	0xe8, 0x5f, 0xd3, 0x65, 0xb3, 0x2c, 0x7c, 0xbf, 0xbd, 0xee, 0xbb, 0xf3, 0x73, 0xba, 0xf4, 0x42,
	0x96, 0x2c, 0x31, 0xd7, 0xd9, 0x3f, 0x86, 0x7a, 0x26, 0x40, 0xb6, 0x34, 0x93, 0x9e, 0xf8, 0x27,
	0x7f, 0xdf, 0xc5, 0xe3, 0x31, 0xd5, 0x5b, 0x79, 0x5c, 0xfe, 0x5c, 0x73, 0x3c, 0xa8, 0xc8, 0x2a,
	0xcf, 0x55, 0xb8, 0x59, 0xa3, 0x78, 0x4e, 0x06, 0x5b, 0xc6, 0xd2, 0x6e, 0x37, 0x0b, 0xcf, 0x0b,
	0x27, 0xd1, 0xd4, 0x0f, 0x67, 0x58, 0x60, 0x8f, 0xcb, 0x4d, 0xcd, 0x99, 0x40, 0xc5, 0x4b, 0x92,
	0x28, 0xe1, 0x61, 0x4c, 0xa2, 0xa9, 0xf4, 0xb2, 0x83, 0xc5, 0x37, 0x6a, 0x42, 0x6d, 0x4e, 0xd3,
	0x94, 0xcc, 0xb2, 0xfd, 0xb3, 0x25, 0x6a, 0x83, 0x31, 0x25, 0x8c, 0xa8, 0xe7, 0xba, 0xb5, 0x6e,
	0xb0, 0xd0, 0x10, 0x9b, 0xb8, 0x60, 0xe6, 0xb5, 0xcb, 0x2f, 0x75, 0xea, 0xcf, 0x7c, 0x96, 0x2a,
	0xc6, 0x53, 0x2b, 0x4e, 0x86, 0x71, 0x42, 0x27, 0x7e, 0xea, 0x47, 0x32, 0x57, 0x3b, 0xb8, 0x10,
	0x38, 0x3f, 0x02, 0x6b, 0xa5, 0x92, 0xd1, 0xc1, 0x7a, 0xce, 0xb7, 0x31, 0x46, 0xa6, 0xe0, 0xfc,
	0x5d, 0x03, 0x7b, 0xb8, 0xb8, 0xe1, 0x34, 0x7e, 0x43, 0x31, 0xfd, 0x66, 0x41, 0x53, 0x86, 0x8e,
	0xc1, 0x4c, 0x33, 0x99, 0xa2, 0xae, 0xb7, 0xd4, 0x83, 0x91, 0xe2, 0x98, 0x33, 0x74, 0xcf, 0x4f,
	0x99, 0xa0, 0x8c, 0x4c, 0x15, 0xb5, 0xc0, 0x88, 0xa3, 0x20, 0xe3, 0xa9, 0x8c, 0xed, 0xa2, 0x20,
	0xb8, 0x2c, 0x61, 0x81, 0xa0, 0x4f, 0xa0, 0x26, 0x58, 0x58, 0x31, 0x54, 0xfe, 0x7a, 0x5d, 0x2e,
	0x54, 0x0e, 0x33, 0x0d, 0xf4, 0x3d, 0x30, 0xe9, 0x73, 0x46, 0x43, 0x11, 0xb4, 0xa4, 0xe1, 0x37,
	0x3a, 0x79, 0xdb, 0xf0, 0x32, 0x08, 0x17, 0x5a, 0x27, 0x26, 0xd4, 0x12, 0x19, 0x84, 0x53, 0x05,
	0x83, 0x6f, 0xed, 0xfc, 0x55, 0x83, 0xbd, 0x95, 0x08, 0xd3, 0x38, 0x0a, 0x53, 0x8a, 0x3e, 0xcd,
	0xbb, 0x80, 0x8c, 0x0f, 0xc9, 0x73, 0xac, 0x76, 0x20, 0xfe, 0xb6, 0x55, 0x37, 0xf8, 0x10, 0x76,
	0xd2, 0x65, 0x38, 0x19, 0x27, 0xca, 0x5c, 0x44, 0xc8, 0x89, 0xad, 0xc1, 0xc5, 0xb9, 0xd3, 0x8f,
	0xa0, 0x42, 0x79, 0xbd, 0xa8, 0xd8, 0x14, 0x9b, 0x8b, 0x12, 0xe2, 0xef, 0xee, 0xb2, 0x84, 0x25,
	0xfe, 0x6d, 0x22, 0x03, 0xa8, 0x67, 0xbb, 0x3b, 0x7f, 0xd4, 0xf3, 0xa4, 0xe5, 0x99, 0x58, 0xe9,
	0x88, 0xda, 0x4b, 0x3b, 0xe2, 0x31, 0x34, 0xd2, 0x15, 0x3b, 0xf5, 0x06, 0xd1, 0x66, 0x6e, 0xf1,
	0x9a, 0x1e, 0x7a, 0x1f, 0xac, 0x45, 0x4a, 0xc7, 0x59, 0xea, 0x44, 0xf4, 0x18, 0x16, 0x29, 0x75,
	0x55, 0xaa, 0x1c, 0xd0, 0xbf, 0x89, 0xb2, 0x9c, 0xaa, 0x72, 0xfb, 0xc5, 0x60, 0x78, 0x45, 0x92,
	0xaf, 0xf9, 0x93, 0xe2, 0x20, 0x3a, 0x04, 0x63, 0xce, 0x1f, 0x51, 0x45, 0xbc, 0xba, 0x77, 0xb7,
	0x17, 0x54, 0xe7, 0x2a, 0x9a, 0x52, 0x2c, 0x14, 0xd1, 0x27, 0xb0, 0x47, 0x82, 0x20, 0xfa, 0xcd,
	0x98, 0xcc, 0x66, 0x09, 0x9d, 0x89, 0xa4, 0xa8, 0x56, 0x6b, 0x0b, 0xc0, 0x2d, 0xe4, 0xa8, 0x03,
	0xfc, 0x3c, 0x63, 0x6e, 0x18, 0xa4, 0xcd, 0x9a, 0x08, 0x4c, 0x15, 0x17, 0x77, 0x19, 0x9c, 0x11,
	0x46, 0xb0, 0xb9, 0x48, 0xa9, 0x58, 0xa5, 0xe8, 0x00, 0xea, 0x54, 0xbd, 0x78, 0xd1, 0x13, 0x36,
	0x79, 0x20, 0xc7, 0xd1, 0x03, 0x68, 0xc8, 0x42, 0x48, 0xc7, 0x51, 0x18, 0x2c, 0x45, 0x43, 0xa8,
	0x63, 0x4b, 0xc9, 0x06, 0x61, 0xb0, 0x74, 0x1e, 0x82, 0xc1, 0x1d, 0x23, 0x80, 0xea, 0x70, 0x84,
	0x3d, 0xf7, 0xca, 0x2e, 0xa1, 0x3a, 0x18, 0x83, 0xfe, 0xa9, 0x67, 0x6b, 0xfc, 0xeb, 0x7a, 0xd0,
	0xeb, 0xd9, 0x65, 0xe7, 0x9f, 0x1a, 0x34, 0x56, 0x63, 0x7e, 0xe5, 0x84, 0x70, 0xa0, 0x6e, 0x4d,
	0x72, 0xd5, 0x96, 0x67, 0xb8, 0x72, 0x61, 0x1f, 0xc1, 0xbd, 0x94, 0xcc, 0xe3, 0x80, 0x8e, 0xfd,
	0x90, 0xd1, 0x24, 0x6f, 0xcf, 0x78, 0x57, 0x8a, 0xbb, 0x4a, 0x8a, 0x3e, 0x03, 0x94, 0x2e, 0xe2,
	0x38, 0xa1, 0x69, 0x3a, 0x4e, 0xe8, 0x74, 0x11, 0x4e, 0x49, 0x28, 0x79, 0xbc, 0x8e, 0xf7, 0x32,
	0x04, 0x67, 0x00, 0x57, 0x7f, 0x4a, 0x49, 0xc2, 0x6e, 0x28, 0x61, 0x85, 0xeb, 0x8a, 0x70, 0xbd,
	0x97, 0x23, 0x99, 0x77, 0xe7, 0x21, 0x40, 0x91, 0x7b, 0xc1, 0x93, 0xf2, 0x53, 0xd1, 0x67, 0xb6,
	0x74, 0xbe, 0x80, 0x8a, 0xa8, 0x9f, 0x57, 0xde, 0x41, 0x3e, 0xc8, 0x95, 0x57, 0x06, 0x39, 0xa7,
	0x03, 0x66, 0x4e, 0x1b, 0xe8, 0x41, 0xa6, 0x22, 0x19, 0xcf, 0x5a, 0xa1, 0x95, 0x4c, 0xff, 0x6f,
	0x1a, 0xc0, 0x90, 0xb2, 0x8c, 0xe4, 0xee, 0xf2, 0x5e, 0x8a, 0x29, 0xb0, 0xfc, 0xd2, 0x29, 0xf0,
	0x21, 0xa7, 0x9c, 0x38, 0x20, 0x13, 0xaa, 0xda, 0xe5, 0xfa, 0x40, 0x99, 0x81, 0x77, 0x9c, 0x3b,
	0x5f, 0x9f, 0x19, 0x9c, 0x7f, 0x68, 0x60, 0x89, 0xb8, 0x14, 0x0b, 0xdd, 0x25, 0xb0, 0x4e, 0xc1,
	0x26, 0xeb, 0x24, 0xa0, 0x8e, 0x43, 0xd3, 0x45, 0xc0, 0x70, 0xae, 0x83, 0x3e, 0x2e, 0x9a, 0x9d,
	0xbe, 0x95, 0xdb, 0x8a, 0xee, 0xb7, 0x36, 0xb7, 0x1b, 0x2f, 0xce, 0xed, 0xdf, 0x22, 0xbe, 0xff,
	0x68, 0xd0, 0x58, 0x3d, 0x16, 0x6a, 0x6d, 0xfc, 0x33, 0x10, 0x27, 0x58, 0xd9, 0x25, 0x2b, 0xa8,
	0xf2, 0x4b, 0x0a, 0xea, 0x35, 0xc2, 0xf9, 0x14, 0xca, 0x91, 0x8c, 0x63, 0xf7, 0xe8, 0xfe, 0xe6,
	0x1d, 0x75, 0x06, 0x31, 0x4d, 0x04, 0x03, 0xe1, 0x72, 0x14, 0x3b, 0x5f, 0x80, 0x99, 0x0b, 0x90,
	0x05, 0xb5, 0x6e, 0xff, 0x89, 0xdb, 0xeb, 0x9e, 0xd9, 0x25, 0x4e, 0x0c, 0x67, 0x5e, 0xcf, 0x1b,
	0x71, 0x3a, 0xb0, 0xa0, 0x86, 0xbd, 0xeb, 0x9e, 0x7b, 0xea, 0xd9, 0x65, 0x0e, 0x7c, 0x75, 0x7d,
	0xe6, 0x8e, 0x3c, 0x5b, 0x77, 0xfe, 0x52, 0x06, 0xb8, 0x78, 0xbd, 0x12, 0x2d, 0x42, 0xd5, 0xb7,
	0x86, 0xfa, 0x99, 0x9a, 0x75, 0x74, 0x11, 0xc1, 0x3b, 0x12, 0x2f, 0xf6, 0xe8, 0x70, 0x5e, 0xe4,
	0x83, 0x81, 0x1c, 0x7b, 0xd6, 0x68, 0xb1, 0xf2, 0x0a, 0x5a, 0x5c, 0xa7, 0xdc, 0xea, 0x2b, 0x29,
	0x77, 0x2d, 0xf7, 0xb5, 0x3b, 0xe5, 0xfe, 0xc7, 0x50, 0xcf, 0x0e, 0x88, 0x6a, 0xa0, 0xbb, 0xbd,
	0x9e, 0xbc, 0xca, 0xd3, 0x41, 0xff, 0xbc, 0x7b, 0x61, 0x6b, 0xc8, 0x84, 0xca, 0x70, 0xc4, 0x2f,
	0xaf, 0x8c, 0xee, 0x81, 0x35, 0xb8, 0xf6, 0xb0, 0x3b, 0xea, 0x0e, 0xfa, 0x6e, 0xcf, 0xd6, 0x9d,
	0x3f, 0x68, 0x60, 0x5d, 0xac, 0x3c, 0x8c, 0x63, 0x68, 0x84, 0x2b, 0xfd, 0x5d, 0x51, 0xc5, 0x96,
	0xce, 0x8f, 0xd7, 0xf4, 0xf8, 0x9f, 0x34, 0xd9, 0xd6, 0xcb, 0xdb, 0x6b, 0x65, 0x5b, 0x53, 0xd7,
	0xef, 0x14, 0xde, 0x39, 0xec, 0x9d, 0x92, 0x98, 0xdc, 0xf8, 0x81, 0xcf, 0x96, 0x59, 0xd6, 0xd7,
	0xfc, 0x68, 0x77, 0xf2, 0xf3, 0x6f, 0x0d, 0xd0, 0xaa, 0x23, 0x15, 0xf0, 0x63, 0xb0, 0x39, 0x99,
	0x47, 0x09, 0xa3, 0xd3, 0x2c, 0x4d, 0xda, 0xf6, 0x34, 0xdd, 0xcb, 0x15, 0x55, 0xb2, 0x7e, 0x0a,
	0x6f, 0x14, 0xb6, 0x59, 0xca, 0x53, 0x51, 0x66, 0x9b, 0x35, 0x81, 0x72, 0xd5, 0x4c, 0x94, 0xf2,
	0xa6, 0x39, 0xeb, 0x5f, 0x75, 0xc7, 0xcf, 0x68, 0xa2, 0x6e, 0x84, 0x73, 0xb7, 0xc5, 0x65, 0x4f,
	0xa4, 0x68, 0x3d, 0x52, 0xe3, 0x4e, 0x91, 0xfe, 0x0a, 0xcc, 0xfc, 0xd0, 0x5b, 0xff, 0x5d, 0x38,
	0xd0, 0x88, 0x92, 0x19, 0x09, 0xfd, 0xdf, 0x12, 0x96, 0x0d, 0xcb, 0x26, 0x5e, 0x93, 0xf1, 0x96,
	0xb4, 0x7e, 0xaa, 0x6c, 0x79, 0x70, 0x06, 0xf5, 0x2c, 0x02, 0xde, 0xb4, 0x7f, 0x36, 0x1c, 0xf4,
	0xed, 0x12, 0x2f, 0xb2, 0x93, 0x5f, 0x8e, 0xbc, 0xa1, 0xac, 0xb7, 0x6b, 0x3c, 0x18, 0x0d, 0xec,
	0x32, 0xff, 0x74, 0x87, 0xa7, 0xdd, 0xae, 0xad, 0xa3, 0x1d, 0x30, 0xb9, 0xea, 0xb8, 0xeb, 0x8d,
	0xce, 0x6d, 0xe3, 0xc0, 0x5d, 0x1f, 0xcf, 0xc4, 0x60, 0x80, 0x60, 0x77, 0xe4, 0xe2, 0x0b, 0x6f,
	0x34, 0x3e, 0xf3, 0xce, 0xbb, 0x7d, 0x8f, 0x73, 0xc2, 0x0e, 0x98, 0x83, 0xfe, 0xf8, 0xf4, 0xd2,
	0xed, 0x5f, 0x70, 0x5a, 0xe0, 0xb3, 0x83, 0x7b, 0x75, 0xdd, 0xf3, 0xec, 0xf2, 0xd1, 0xbf, 0x34,
	0x30, 0xf8, 0x55, 0x21, 0x17, 0x1a, 0x79, 0x66, 0x7d, 0x9a, 0x22, 0xf5, 0x87, 0x69, 0xa3, 0x6c,
	0xf6, 0x9b, 0x9b, 0x80, 0x2a, 0x83, 0x03, 0xd0, 0x2f, 0x28, 0x43, 0xf6, 0x8b, 0x6f, 0x7f, 0x7f,
	0x6f, 0x45, 0x52, 0xe8, 0x0e, 0x0b, 0xdd, 0xe1, 0x86, 0xee, 0x6a, 0xa3, 0xf9, 0x12, 0xcc, 0x7c,
	0xb0, 0x46, 0xeb, 0x93, 0x49, 0xfe, 0x5f, 0x62, 0xff, 0xed, 0x0d, 0xb9, 0xb4, 0x6e, 0x6b, 0x8f,
	0xb4, 0xc7, 0x5f, 0x42, 0x43, 0xa4, 0x3b, 0xa5, 0xc9, 0x33, 0x7f, 0x42, 0xd1, 0xfd, 0x8d, 0xff,
	0x4a, 0xe7, 0x7e, 0x40, 0x07, 0xe2, 0x16, 0xd3, 0xe6, 0x7f, 0x6b, 0xaa, 0x84, 0xc2, 0xb9, 0x3f,
	0x94, 0x16, 0x27, 0xf5, 0x3f, 0xff, 0xa4, 0xf2, 0xa8, 0xf3, 0xc3, 0xce, 0xa3, 0x9b, 0xaa, 0xb0,
	0xf9, 0xfe, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0xe1, 0x84, 0x75, 0xee, 0xdd, 0x12, 0x00, 0x00,
}
