/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sf;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.tinyos.packet.PacketListenerIF;
import net.tinyos.packet.SFProtocol;
import net.tinyos.sf.SFListen;
import net.tinyos.sf.SerialForwarder;

public class SFClient
extends SFProtocol
implements Runnable,
PacketListenerIF {
    private Thread thread = new Thread(this);
    private Socket socket = null;
    private SerialForwarder sf;
    private SFListen listenServer;

    public SFClient(Socket socket, SerialForwarder serialForwarder, SFListen sFListen) {
        super("");
        this.sf = serialForwarder;
        this.listenServer = sFListen;
        this.socket = socket;
        InetAddress inetAddress = socket.getInetAddress();
        this.name = "client at " + inetAddress.getHostName() + " (" + inetAddress.getHostAddress() + ")";
        this.sf.debug.message("new " + this.name);
    }

    protected void openSource() throws IOException {
        this.is = this.socket.getInputStream();
        this.os = this.socket.getOutputStream();
        super.openSource();
    }

    protected void closeSource() throws IOException {
        this.socket.close();
    }

    private void init() throws IOException {
        this.sf.incrementClients();
        this.open(this.sf);
        this.listenServer.source.registerPacketListener(this);
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        this.thread.start();
    }

    public final void join(long l) throws InterruptedException {
        this.thread.join(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.init();
            this.readPackets();
        }
        catch (IOException iOException) {
        }
        finally {
            this.listenServer.source.deregisterPacketListener(this);
            this.listenServer.removeSFClient(this);
            this.sf.decrementClients();
            this.shutdown();
        }
    }

    private void readPackets() throws IOException {
        while (true) {
            byte[] byArray = this.readPacket();
            this.sf.incrementPacketsWritten();
            if (this.listenServer.source.writePacket(byArray)) continue;
            this.sf.verbose.message("write failed");
        }
    }

    public void packetReceived(byte[] byArray) {
        try {
            this.writePacket(byArray);
        }
        catch (IOException iOException) {
            this.shutdown();
        }
    }
}

