/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_property
#define _vdkb_property
#include <vdk/vdkstring.h>
#include <vdk/value_sem_list.h>
#define NIHIL_PROP (char*) "nihil"
extern "C"
{
#include <string.h>
}
//=========================
class VDKBProperty
{
 protected:
  VDKString name,value;
 public:
  VDKBProperty() {};
  VDKBProperty(const char* n, const char* v = NULL):
    name(n),value(v ? v : NIHIL_PROP)
    { 
    }
  ~VDKBProperty() {};
  char* Value(const char* v = NULL) { if(v) value = v; return (char*) value; }
  char* Name() { return (char*) name; }
  VDKString& Property() { return value; }
  bool operator==(VDKBProperty& p)
    { return name == p.name; }
  bool operator<(VDKBProperty& p)
    { return name < p.name; }
};
//===========================================================
typedef VDKValueList<VDKBProperty> VDKBPList;
typedef VDKValueListIterator<VDKBProperty> VDKBPListIterator;
//===========================================================
class VDKBPropertyList: public VDKBPList
{
 protected:

 public:
  VDKBPropertyList() {}
  ~VDKBPropertyList(){}
};

#endif




