/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Option
implements Serializable {
    static final long serialVersionUID = 2734100173861424920L;
    public static final long UNSET = -2L;
    public static final long BUFPOLICY_RING = 0L;
    public static final long BUFPOLICY_FILL = 1L;
    public static final long BUFPOLICY_SWITCH = 2L;
    public static final long BUFRESIZE_AUTO = 0L;
    public static final long BUFRESIZE_MANUAL = 1L;
    public static final String VALUE_SET = "set";
    public static final String VALUE_UNSET = "unset";
    public static final String VALUE_RING = "ring";
    public static final String VALUE_FILL = "fill";
    public static final String VALUE_SWITCH = "switch";
    public static final String VALUE_AUTO = "auto";
    public static final String VALUE_MANUAL = "manual";
    public static final String amin = "amin";
    public static final String argref = "argref";
    public static final String cpp = "cpp";
    public static final String cpppath = "cpppath";
    public static final String defaultargs = "defaultargs";
    public static final String define = "define";
    public static final String empty = "empty";
    public static final String errtags = "errtags";
    public static final String incdir = "incdir";
    public static final String knodefs = "knodefs";
    public static final String libdir = "libdir";
    public static final String stdc = "stdc";
    public static final String undef = "undef";
    public static final String unodefs = "unodefs";
    public static final String version = "version";
    public static final String zdefs = "zdefs";
    public static final String aggrate = "aggrate";
    public static final String aggsize = "aggsize";
    public static final String aggsortkey = "aggsortkey";
    public static final String aggsortkeypos = "aggsortkeypos";
    public static final String aggsortpos = "aggsortpos";
    public static final String aggsortrev = "aggsortrev";
    public static final String bufsize = "bufsize";
    public static final String bufpolicy = "bufpolicy";
    public static final String bufresize = "bufresize";
    public static final String cleanrate = "cleanrate";
    public static final String cpu = "cpu";
    public static final String destructive = "destructive";
    public static final String dynvarsize = "dynvarsize";
    public static final String flowindent = "flowindent";
    public static final String nspec = "nspec";
    public static final String quiet = "quiet";
    public static final String specsize = "specsize";
    public static final String stackframes = "stackframes";
    public static final String statusrate = "statusrate";
    public static final String strsize = "strsize";
    public static final String switchrate = "switchrate";
    public static final String ustackframes = "ustackframes";
    private final String name;
    private final String value;

    public static String kb(int n) {
        return Integer.toString(n) + "k";
    }

    public static String mb(int n) {
        return Integer.toString(n) + "m";
    }

    public static String gb(int n) {
        return Integer.toString(n) + "g";
    }

    public static String tb(int n) {
        return Integer.toString(n) + "t";
    }

    public static String nanos(int n) {
        return Integer.toString(n) + "ns";
    }

    public static String micros(int n) {
        return Integer.toString(n) + "us";
    }

    public static String millis(int n) {
        return Integer.toString(n) + "ms";
    }

    public static String seconds(int n) {
        return Integer.toString(n) + "s";
    }

    public static String minutes(int n) {
        return Integer.toString(n) + "m";
    }

    public static String hours(int n) {
        return Integer.toString(n) + "h";
    }

    public static String days(int n) {
        return Integer.toString(n) + "d";
    }

    public static String hz(int n) {
        return Integer.toString(n) + "hz";
    }

    public Option(String optionName) {
        this(optionName, VALUE_SET);
    }

    public Option(String optionName, String optionValue) {
        this.name = optionName;
        this.value = optionValue;
        this.validate();
    }

    private final void validate() {
        if (this.name == null) {
            throw new NullPointerException("option name is null");
        }
        if (this.value == null) {
            throw new NullPointerException("option value is null");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof Option) {
            Option opt = (Option)o;
            return this.name.equals(opt.name) && this.value.equals(opt.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.value.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Option.class.getName());
        buf.append("[name = ");
        buf.append(this.name);
        buf.append(", value = ");
        buf.append(this.value);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Option.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"name", "value"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

