/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import jsyntaxpane.Lexer;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static Font DEFAULT_FONT;
    private static Set<String> CONTENTS;
    private static boolean initialized;
    private Lexer lexer;
    private static final Logger LOG;
    public static final Pattern COMMA_REGEX;
    private List<SyntaxComponent> editorComponents = new ArrayList<SyntaxComponent>();
    private Map<String, SyntaxAction> editorActions = new HashMap<String, SyntaxAction>();
    private static Configuration CONFIG;

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public View create(Element element) {
        return new SyntaxView(element, CONFIG, this.getClass().getSimpleName());
    }

    public void install(JEditorPane editorPane) {
        String[] components;
        super.install(editorPane);
        editorPane.setFont(DEFAULT_FONT);
        Keymap km_parent = JTextComponent.getKeymap("default");
        Keymap km_new = JTextComponent.addKeymap(null, km_parent);
        String kitName = this.getClass().getSimpleName();
        Color caretColor = CONFIG.getPrefixColor(kitName, "CaretColor", Color.BLACK);
        editorPane.setCaretColor(caretColor);
        this.addSyntaxActions(km_new, "");
        this.addSyntaxActions(km_new, kitName);
        editorPane.setKeymap(km_new);
        for (String c : components = CONFIG.getPrefixPropertyList(kitName, "Components")) {
            try {
                Class<?> compClass = Class.forName(c);
                SyntaxComponent comp = (SyntaxComponent)compClass.newInstance();
                comp.config(CONFIG, kitName);
                comp.install(editorPane);
                this.editorComponents.add(comp);
            }
            catch (InstantiationException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void deinstall(JEditorPane editorPane) {
        for (SyntaxComponent c : this.editorComponents) {
            c.deinstall(editorPane);
        }
        this.editorComponents.clear();
    }

    public void addSyntaxActions(Keymap map, String prefix) {
        Pattern splitter = CONFIG.getValueSeparator(prefix);
        Configuration actionsConf = CONFIG.subConfig(prefix, "Action.");
        for (String actionName : actionsConf.stringPropertyNames()) {
            String keyStrokeString;
            KeyStroke ks;
            String[] values = splitter.split(actionsConf.getProperty(actionName));
            String actionClass = values[0];
            SyntaxAction action = this.editorActions.get(actionClass);
            if (action == null) {
                action = this.createAction(actionClass);
                action.config(CONFIG, prefix, actionName);
            }
            if ((ks = KeyStroke.getKeyStroke(keyStrokeString = values[1])) == null) {
                throw new IllegalArgumentException("Invalid KeyStroke: " + keyStrokeString);
            }
            TextAction ta = action.getAction(actionName);
            if (ta == null) {
                throw new IllegalArgumentException("Invalid ActionName: " + actionName);
            }
            map.addActionForKeyStroke(ks, ta);
        }
    }

    private SyntaxAction createAction(String actionClassName) {
        SyntaxAction action = null;
        try {
            Class clazz = JarServiceProvider.loadClass(actionClassName);
            action = (SyntaxAction)clazz.newInstance();
            this.editorActions.put(actionClassName, action);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        return action;
    }

    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static void initKit() {
        CONFIG = new Configuration(JarServiceProvider.readProperties("jsyntaxpane.config"));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fonts = ge.getAvailableFontFamilyNames();
        Arrays.sort(fonts);
        if (Arrays.binarySearch(fonts, "Courier new") >= 0) {
            DEFAULT_FONT = new Font("Courier New", 0, 12);
        } else if (Arrays.binarySearch(fonts, "Courier") >= 0) {
            DEFAULT_FONT = new Font("Courier", 0, 12);
        } else if (Arrays.binarySearch(fonts, "Monospaced") >= 0) {
            DEFAULT_FONT = new Font("Monospaced", 0, 13);
        }
        Properties kitsForTypes = JarServiceProvider.readProperties("jsyntaxpane.kitsfortypes");
        for (String type : kitsForTypes.stringPropertyNames()) {
            String classname = kitsForTypes.getProperty(type);
            DefaultSyntaxKit.registerContentType(type, classname);
        }
        initialized = true;
    }

    public static void registerContentType(String type, String classname) {
        JEditorPane.registerEditorKitForContentType(type, classname);
        CONTENTS.add(type);
    }

    public static String[] getContentTypes() {
        Object[] types = CONTENTS.toArray(new String[0]);
        Arrays.sort(types);
        return types;
    }

    public static Configuration getConfig() {
        if (!initialized) {
            DefaultSyntaxKit.initKit();
        }
        return CONFIG;
    }

    public static void setConfig(Properties config) {
        CONFIG.putAll((Map<?, ?>)config);
    }

    public static void setProperty(String key, String value) {
        if (!initialized) {
            DefaultSyntaxKit.initKit();
        }
        CONFIG.put(key, value);
    }

    public static String getProperty(String key) {
        if (!initialized) {
            DefaultSyntaxKit.initKit();
        }
        return CONFIG.getProperty(key);
    }

    static {
        CONTENTS = new HashSet<String>();
        initialized = false;
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        COMMA_REGEX = Pattern.compile("\\w+,\\w+");
        DefaultSyntaxKit.initKit();
    }
}

