/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* writerperfect
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004-2006 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

#include "StringDocumentHandler.hxx"

StringDocumentHandler::StringDocumentHandler()
	: m_serializer()
{
}

void StringDocumentHandler::startDocument()
{
	m_serializer.startDocument();
}

void StringDocumentHandler::endDocument()
{
	m_serializer.endDocument();
}

void StringDocumentHandler::startElement(const char *psName, const librevenge::RVNGPropertyList &xPropList)
{
	m_serializer.startElement(psName, xPropList);
}

void StringDocumentHandler::endElement(const char *psName)
{
	m_serializer.endElement(psName);
}

void StringDocumentHandler::characters(const librevenge::RVNGString &sCharacters)
{
	m_serializer.characters(sCharacters);
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
